/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClusterHealthAction
extends TransportMasterNodeReadAction<ClusterHealthRequest, ClusterHealthResponse> {
    private final ClusterName clusterName;
    private final GatewayAllocator gatewayAllocator;

    @Inject
    public TransportClusterHealthAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ClusterName clusterName, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, GatewayAllocator gatewayAllocator) {
        super(settings, "cluster:monitor/health", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, ClusterHealthRequest.class);
        this.clusterName = clusterName;
        this.gatewayAllocator = gatewayAllocator;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(ClusterHealthRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected ClusterHealthResponse newResponse() {
        return new ClusterHealthResponse();
    }

    @Override
    protected void masterOperation(final ClusterHealthRequest request, ClusterState unusedState, final ActionListener<ClusterHealthResponse> listener) {
        if (request.waitForEvents() != null) {
            final long endTimeMS = TimeValue.nsecToMSec(System.nanoTime()) + request.timeout().millis();
            this.clusterService.submitStateUpdateTask("cluster_health (wait_for_events [" + request.waitForEvents() + "])", new ClusterStateUpdateTask(request.waitForEvents()){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    return currentState;
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    long timeoutInMillis = Math.max(0L, endTimeMS - TimeValue.nsecToMSec(System.nanoTime()));
                    TimeValue newTimeout = TimeValue.timeValueMillis(timeoutInMillis);
                    request.timeout(newTimeout);
                    TransportClusterHealthAction.this.executeHealth(request, listener);
                }

                @Override
                public void onNoLongerMaster(String source) {
                    TransportClusterHealthAction.this.logger.trace("stopped being master while waiting for events with priority [{}]. retrying.", request.waitForEvents());
                    TransportClusterHealthAction.this.doExecute(request, listener);
                }

                @Override
                public void onFailure(String source, Throwable t) {
                    TransportClusterHealthAction.this.logger.error("unexpected failure during [{}]", t, source);
                    listener.onFailure(t);
                }

                @Override
                public boolean runOnlyOnMaster() {
                    return !request.local();
                }
            });
        } else {
            this.executeHealth(request, listener);
        }
    }

    private void executeHealth(final ClusterHealthRequest request, final ActionListener<ClusterHealthResponse> listener) {
        int waitFor = 5;
        if (request.waitForStatus() == null) {
            --waitFor;
        }
        if (request.waitForRelocatingShards() == -1) {
            --waitFor;
        }
        if (request.waitForActiveShards() == -1) {
            --waitFor;
        }
        if (request.waitForNodes().isEmpty()) {
            --waitFor;
        }
        if (request.indices() == null || request.indices().length == 0) {
            --waitFor;
        }
        assert (waitFor >= 0);
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, this.logger);
        ClusterState state = observer.observedState();
        if (waitFor == 0 || request.timeout().millis() == 0L) {
            listener.onResponse(this.getResponse(request, state, waitFor, request.timeout().millis() == 0L));
            return;
        }
        final int concreteWaitFor = waitFor;
        ClusterStateObserver.ValidationPredicate validationPredicate = new ClusterStateObserver.ValidationPredicate(){

            @Override
            protected boolean validate(ClusterState newState) {
                return newState.status() == ClusterState.ClusterStateStatus.APPLIED && TransportClusterHealthAction.this.validateRequest(request, newState, concreteWaitFor);
            }
        };
        ClusterStateObserver.Listener stateListener = new ClusterStateObserver.Listener(){

            @Override
            public void onNewClusterState(ClusterState clusterState) {
                listener.onResponse(TransportClusterHealthAction.this.getResponse(request, clusterState, concreteWaitFor, false));
            }

            @Override
            public void onClusterServiceClose() {
                listener.onFailure(new IllegalStateException("ClusterService was close during health call"));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                ClusterState clusterState = TransportClusterHealthAction.this.clusterService.state();
                ClusterHealthResponse response = TransportClusterHealthAction.this.getResponse(request, clusterState, concreteWaitFor, true);
                listener.onResponse(response);
            }
        };
        if (state.status() == ClusterState.ClusterStateStatus.APPLIED && this.validateRequest(request, state, concreteWaitFor)) {
            stateListener.onNewClusterState(state);
        } else {
            observer.waitForNextChange(stateListener, validationPredicate, request.timeout());
        }
    }

    private boolean validateRequest(ClusterHealthRequest request, ClusterState clusterState, int waitFor) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.numberOfPendingTasks(), this.gatewayAllocator.getNumberOfInFlightFetch(), this.clusterService.getMaxTaskWaitTime());
        return this.prepareResponse(request, response, clusterState, waitFor);
    }

    private ClusterHealthResponse getResponse(ClusterHealthRequest request, ClusterState clusterState, int waitFor, boolean timedOut) {
        ClusterHealthResponse response = this.clusterHealth(request, clusterState, this.clusterService.numberOfPendingTasks(), this.gatewayAllocator.getNumberOfInFlightFetch(), this.clusterService.getMaxTaskWaitTime());
        boolean valid = this.prepareResponse(request, response, clusterState, waitFor);
        assert (valid || timedOut);
        response.setTimedOut(timedOut && !valid);
        return response;
    }

    private boolean prepareResponse(ClusterHealthRequest request, ClusterHealthResponse response, ClusterState clusterState, int waitFor) {
        int waitForCounter = 0;
        if (request.waitForStatus() != null && response.getStatus().value() <= request.waitForStatus().value()) {
            ++waitForCounter;
        }
        if (request.waitForRelocatingShards() != -1 && response.getRelocatingShards() <= request.waitForRelocatingShards()) {
            ++waitForCounter;
        }
        if (request.waitForActiveShards() != -1 && response.getActiveShards() >= request.waitForActiveShards()) {
            ++waitForCounter;
        }
        if (request.indices() != null && request.indices().length > 0) {
            try {
                this.indexNameExpressionResolver.concreteIndices(clusterState, IndicesOptions.strictExpand(), request.indices());
                ++waitForCounter;
            }
            catch (IndexNotFoundException e) {
                response.setStatus(ClusterHealthStatus.RED);
            }
        }
        if (!request.waitForNodes().isEmpty()) {
            if (request.waitForNodes().startsWith(">=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("ge(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() >= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<=")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(2));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("le(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() <= expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith(">")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("gt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() > expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("<")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else if (request.waitForNodes().startsWith("lt(")) {
                int expected = Integer.parseInt(request.waitForNodes().substring(3, request.waitForNodes().length() - 1));
                if (response.getNumberOfNodes() < expected) {
                    ++waitForCounter;
                }
            } else {
                int expected = Integer.parseInt(request.waitForNodes());
                if (response.getNumberOfNodes() == expected) {
                    ++waitForCounter;
                }
            }
        }
        return waitForCounter == waitFor;
    }

    private ClusterHealthResponse clusterHealth(ClusterHealthRequest request, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, TimeValue pendingTaskTimeInQueue) {
        String[] concreteIndices;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Calculating health based on state version [{}]", clusterState.version());
        }
        try {
            concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, request);
        }
        catch (IndexNotFoundException e) {
            ClusterHealthResponse response = new ClusterHealthResponse(this.clusterName.value(), Strings.EMPTY_ARRAY, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
            response.setStatus(ClusterHealthStatus.RED);
            return response;
        }
        return new ClusterHealthResponse(this.clusterName.value(), concreteIndices, clusterState, numberOfPendingTasks, numberOfInFlightFetch, UnassignedInfo.getNumberOfDelayedUnassigned(clusterState), pendingTaskTimeInQueue);
    }
}

