/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.validate.template;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.validate.template.RenderSearchTemplateRequest;
import org.elasticsearch.action.admin.cluster.validate.template.RenderSearchTemplateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRenderSearchTemplateAction
extends HandledTransportAction<RenderSearchTemplateRequest, RenderSearchTemplateResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportRenderSearchTemplateAction(ScriptService scriptService, Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/render/template/search", threadPool, transportService, actionFilters, indexNameExpressionResolver, RenderSearchTemplateRequest.class);
        this.scriptService = scriptService;
    }

    @Override
    protected void doExecute(final RenderSearchTemplateRequest request, final ActionListener<RenderSearchTemplateResponse> listener) {
        this.threadPool.generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Throwable t) {
                listener.onFailure(t);
            }

            @Override
            protected void doRun() throws Exception {
                ExecutableScript executable = TransportRenderSearchTemplateAction.this.scriptService.executable(request.template(), ScriptContext.Standard.SEARCH, request);
                BytesReference processedTemplate = (BytesReference)executable.run();
                RenderSearchTemplateResponse response = new RenderSearchTemplateResponse();
                response.source(processedTemplate);
                listener.onResponse(response);
            }
        });
    }
}

