/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryParser;

public class IndicesQueriesRegistry
extends AbstractComponent {
    private ImmutableMap<String, QueryParser> queryParsers;

    @Inject
    public IndicesQueriesRegistry(Settings settings, Set<QueryParser> injectedQueryParsers) {
        super(settings);
        HashMap queryParsers = Maps.newHashMap();
        for (QueryParser queryParser : injectedQueryParsers) {
            for (String name : queryParser.names()) {
                queryParsers.put(name, queryParser);
            }
        }
        this.queryParsers = ImmutableMap.copyOf((Map)queryParsers);
    }

    public ImmutableMap<String, QueryParser> queryParsers() {
        return this.queryParsers;
    }
}

