/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.xcontent.FromXContentBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.repositories.blobstore.BlobStoreFormat;

public class LegacyBlobStoreFormat<T extends ToXContent>
extends BlobStoreFormat<T> {
    public LegacyBlobStoreFormat(String blobNameFormat, FromXContentBuilder<T> reader, ParseFieldMatcher parseFieldMatcher) {
        super(blobNameFormat, reader, parseFieldMatcher);
    }

    @Override
    public T readBlob(BlobContainer blobContainer, String blobName) throws IOException {
        try (InputStream inputStream = blobContainer.readBlob(blobName);){
            Object t = this.read(new BytesArray(ByteStreams.toByteArray((InputStream)inputStream)));
            return t;
        }
    }
}

