/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestFilterChain;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.support.RestUtils;

public class RestController
extends AbstractLifecycleComponent<RestController> {
    private ImmutableSet<String> relevantHeaders = ImmutableSet.of();
    private final PathTrie<RestHandler> getHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> postHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> putHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> deleteHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> headHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final PathTrie<RestHandler> optionsHandlers = new PathTrie(RestUtils.REST_DECODER);
    private final RestHandlerFilter handlerFilter = new RestHandlerFilter();
    private RestFilter[] filters = new RestFilter[0];

    @Inject
    public RestController(Settings settings) {
        super(settings);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        for (RestFilter filter : this.filters) {
            filter.close();
        }
    }

    public synchronized void registerRelevantHeaders(String ... headers) {
        this.relevantHeaders = new ImmutableSet.Builder().addAll(this.relevantHeaders).add((Object[])headers).build();
    }

    public ImmutableSet<String> relevantHeaders() {
        return this.relevantHeaders;
    }

    public synchronized void registerFilter(RestFilter preProcessor) {
        RestFilter[] copy = new RestFilter[this.filters.length + 1];
        System.arraycopy(this.filters, 0, copy, 0, this.filters.length);
        copy[this.filters.length] = preProcessor;
        Arrays.sort(copy, new Comparator<RestFilter>(){

            @Override
            public int compare(RestFilter o1, RestFilter o2) {
                return Integer.compare(o1.order(), o2.order());
            }
        });
        this.filters = copy;
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        switch (method) {
            case GET: {
                this.getHandlers.insert(path, handler);
                break;
            }
            case DELETE: {
                this.deleteHandlers.insert(path, handler);
                break;
            }
            case POST: {
                this.postHandlers.insert(path, handler);
                break;
            }
            case PUT: {
                this.putHandlers.insert(path, handler);
                break;
            }
            case OPTIONS: {
                this.optionsHandlers.insert(path, handler);
                break;
            }
            case HEAD: {
                this.headHandlers.insert(path, handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't handle [" + (Object)((Object)method) + "] for path [" + path + "]");
            }
        }
    }

    @Nullable
    public RestFilterChain filterChainOrNull(RestFilter executionFilter) {
        if (this.filters.length == 0) {
            return null;
        }
        return new ControllerFilterChain(executionFilter);
    }

    public RestFilterChain filterChain(RestFilter executionFilter) {
        return new ControllerFilterChain(executionFilter);
    }

    public void dispatchRequest(RestRequest request, RestChannel channel) {
        if (!this.checkRequestParameters(request, channel)) {
            return;
        }
        if (this.filters.length == 0) {
            try {
                this.executeHandler(request, channel);
            }
            catch (Throwable e) {
                try {
                    channel.sendResponse(new BytesRestResponse(channel, e));
                }
                catch (Throwable e1) {
                    this.logger.error("failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                }
            }
        } else {
            ControllerFilterChain filterChain = new ControllerFilterChain(this.handlerFilter);
            filterChain.continueProcessing(request, channel);
        }
    }

    boolean checkRequestParameters(RestRequest request, RestChannel channel) {
        if (!channel.detailedErrorsEnabled() && request.paramAsBoolean("error_trace", false)) {
            try {
                XContentBuilder builder = channel.newErrorBuilder();
                builder.startObject().field("error", "error traces in responses are disabled.").endObject().string();
                BytesRestResponse response = new BytesRestResponse(RestStatus.BAD_REQUEST, builder);
                response.addHeader("Content-Type", "application/json");
                channel.sendResponse(response);
            }
            catch (IOException e) {
                this.logger.warn("Failed to send response", e, new Object[0]);
            }
            return false;
        }
        return true;
    }

    void executeHandler(RestRequest request, RestChannel channel) throws Exception {
        RestHandler handler = this.getHandler(request);
        if (handler != null) {
            handler.handleRequest(request, channel);
        } else if (request.method() == RestRequest.Method.OPTIONS) {
            channel.sendResponse(new BytesRestResponse(RestStatus.OK));
        } else {
            channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, "No handler found for uri [" + request.uri() + "] and method [" + (Object)((Object)request.method()) + "]"));
        }
    }

    private RestHandler getHandler(RestRequest request) {
        String path = this.getPath(request);
        RestRequest.Method method = request.method();
        if (method == RestRequest.Method.GET) {
            return this.getHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.POST) {
            return this.postHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.PUT) {
            return this.putHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.DELETE) {
            return this.deleteHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.HEAD) {
            return this.headHandlers.retrieve(path, request.params());
        }
        if (method == RestRequest.Method.OPTIONS) {
            return this.optionsHandlers.retrieve(path, request.params());
        }
        return null;
    }

    private String getPath(RestRequest request) {
        return request.rawPath();
    }

    class RestHandlerFilter
    extends RestFilter {
        RestHandlerFilter() {
        }

        @Override
        public void process(RestRequest request, RestChannel channel, RestFilterChain filterChain) throws Exception {
            RestController.this.executeHandler(request, channel);
        }
    }

    class ControllerFilterChain
    implements RestFilterChain {
        private final RestFilter executionFilter;
        private final AtomicInteger index = new AtomicInteger();

        ControllerFilterChain(RestFilter executionFilter) {
            this.executionFilter = executionFilter;
        }

        @Override
        public void continueProcessing(RestRequest request, RestChannel channel) {
            try {
                int loc = this.index.getAndIncrement();
                if (loc > RestController.this.filters.length) {
                    throw new IllegalStateException("filter continueProcessing was called more than expected");
                }
                if (loc == RestController.this.filters.length) {
                    this.executionFilter.process(request, channel, this);
                } else {
                    RestFilter preProcessor = RestController.this.filters[loc];
                    preProcessor.process(request, channel, this);
                }
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new BytesRestResponse(channel, e));
                }
                catch (IOException e1) {
                    RestController.this.logger.error("Failed to send failure response for uri [" + request.uri() + "]", e1, new Object[0]);
                }
            }
        }
    }
}

