/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.GeoDistanceUtils;
import org.apache.lucene.util.GeoProjectionUtils;
import org.apache.lucene.util.GeoRect;
import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    public static final short BITS = 31;
    private static final double LON_SCALE = 5965232.355555556;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    public static final double TOLERANCE = 1.0E-6;
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;

    private GeoUtils() {
    }

    public static final Long mortonHash(double lon, double lat) {
        return BitUtil.interleave((long)GeoUtils.scaleLon(lon), (long)GeoUtils.scaleLat(lat));
    }

    public static final double mortonUnhashLon(long hash) {
        return GeoUtils.unscaleLon(BitUtil.deinterleave((long)hash));
    }

    public static final double mortonUnhashLat(long hash) {
        return GeoUtils.unscaleLat(BitUtil.deinterleave((long)(hash >>> 1)));
    }

    private static final long scaleLon(double val) {
        return (long)((val - -180.0) * 5965232.355555556);
    }

    private static final long scaleLat(double val) {
        return (long)((val - -90.0) * 1.1930464711111112E7);
    }

    private static final double unscaleLon(long val) {
        return (double)val / 5965232.355555556 + -180.0;
    }

    private static final double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 + -90.0;
    }

    public static double compare(double v1, double v2) {
        double delta = v1 - v2;
        return Math.abs(delta) <= 1.0E-6 ? 0.0 : delta;
    }

    public static double normalizeLon(double lon_deg) {
        if (lon_deg >= -180.0 && lon_deg <= 180.0) {
            return lon_deg;
        }
        double off = (lon_deg + 180.0) % 360.0;
        if (off < 0.0) {
            return 180.0 + off;
        }
        if (off == 0.0 && lon_deg > 0.0) {
            return 180.0;
        }
        return -180.0 + off;
    }

    public static double normalizeLat(double lat_deg) {
        if (lat_deg >= -90.0 && lat_deg <= 90.0) {
            return lat_deg;
        }
        double off = Math.abs((lat_deg + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    public static boolean bboxContains(double lon, double lat, double minLon, double minLat, double maxLon, double maxLat) {
        return GeoUtils.compare(lon, minLon) >= 0.0 && GeoUtils.compare(lon, maxLon) <= 0.0 && GeoUtils.compare(lat, minLat) >= 0.0 && GeoUtils.compare(lat, maxLat) <= 0.0;
    }

    public static boolean pointInPolygon(double[] x, double[] y, double lat, double lon) {
        assert (x.length == y.length);
        boolean inPoly = false;
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i] < lon && x[i - 1] >= lon) && (!(x[i - 1] < lon) || !(x[i] >= lon)) || !(y[i] + (lon - x[i]) / (x[i - 1] - x[i]) * (y[i - 1] - y[i]) < lat)) continue;
            inPoly = !inPoly;
        }
        return inPoly;
    }

    public static String geoTermToString(long term) {
        StringBuilder s = new StringBuilder(64);
        int numberOfLeadingZeros = Long.numberOfLeadingZeros(term);
        for (int i = 0; i < numberOfLeadingZeros; ++i) {
            s.append('0');
        }
        if (term != 0L) {
            s.append(Long.toBinaryString(term));
        }
        return s.toString();
    }

    public static boolean rectDisjoint(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY;
    }

    public static boolean rectWithin(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMinX < bMinX || aMinY < bMinY || aMaxX > bMaxX || aMaxY > bMaxY);
    }

    public static boolean rectCrosses(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !GeoUtils.rectDisjoint(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY) && !GeoUtils.rectWithin(aMinX, aMinY, aMaxX, aMaxY, bMinX, bMinY, bMaxX, bMaxY);
    }

    public static boolean rectContains(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(bMinX < aMinX || bMinY < aMinY || bMaxX > aMaxX || bMaxY > aMaxY);
    }

    public static boolean rectIntersects(double aMinX, double aMinY, double aMaxX, double aMaxY, double bMinX, double bMinY, double bMaxX, double bMaxY) {
        return !(aMaxX < bMinX || aMinX > bMaxX || aMaxY < bMinY || aMinY > bMaxY);
    }

    public static boolean rectCrossesPoly(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        if (GeoUtils.rectDisjoint(rMinX, rMinY, rMaxX, rMaxY, sMinX, sMinY, sMaxX, sMaxY)) {
            return false;
        }
        double[][] bbox = new double[][]{{rMinX, rMinY}, {rMaxX, rMinY}, {rMaxX, rMaxY}, {rMinX, rMaxY}, {rMinX, rMinY}};
        int polyLength = shapeX.length - 1;
        for (int b = 0; b < 4; b = (int)((short)(b + 1))) {
            double a1 = bbox[b + 1][1] - bbox[b][1];
            double b1 = bbox[b][0] - bbox[b + 1][0];
            double c1 = a1 * bbox[b + 1][0] + b1 * bbox[b + 1][1];
            for (int p = 0; p < polyLength; ++p) {
                boolean touching;
                double b2 = shapeX[p] - shapeX[p + 1];
                double a2 = shapeY[p + 1] - shapeY[p];
                double d = a1 * b2 - a2 * b1;
                if (d == 0.0) continue;
                double c2 = a2 * shapeX[p + 1] + b2 * shapeY[p + 1];
                double s = 1.0 / d * (b2 * c1 - b1 * c2);
                double t = 1.0 / d * (a1 * c2 - a2 * c1);
                double x00 = StrictMath.min(bbox[b][0], bbox[b + 1][0]) - 1.0E-6;
                double x01 = StrictMath.max(bbox[b][0], bbox[b + 1][0]) + 1.0E-6;
                double y00 = StrictMath.min(bbox[b][1], bbox[b + 1][1]) - 1.0E-6;
                double y01 = StrictMath.max(bbox[b][1], bbox[b + 1][1]) + 1.0E-6;
                double x10 = StrictMath.min(shapeX[p], shapeX[p + 1]) - 1.0E-6;
                double x11 = StrictMath.max(shapeX[p], shapeX[p + 1]) + 1.0E-6;
                double y10 = StrictMath.min(shapeY[p], shapeY[p + 1]) - 1.0E-6;
                double y11 = StrictMath.max(shapeY[p], shapeY[p + 1]) + 1.0E-6;
                boolean bl = touching = x00 == s && y00 == t || x01 == s && y01 == t || x10 == s && y10 == t || x11 == s && y11 == t;
                if (touching || x00 > s || x01 < s || y00 > t || y01 < t || x10 > s || x11 < s || y10 > t || y11 < t) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean lineCrossesPoly(double x1, double y1, double x2, double y2, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        double a1 = y2 - y1;
        double b1 = x2 - x1;
        double c1 = a1 * x2 + b1 * y2;
        int polyLength = shapeX.length;
        for (int p = 0; p < polyLength; ++p) {
            boolean touching;
            double b2 = shapeX[p] - shapeX[p + 1];
            double a2 = shapeY[p + 1] - shapeY[p];
            double d = a1 * b2 - a2 * b1;
            if (d == 0.0) continue;
            double c2 = a2 * shapeX[p + 1] + b2 * shapeY[p + 1];
            double s = 1.0 / d * (b2 * c1 - b1 * c2);
            double t = 1.0 / d * (a1 * c2 - a2 * c1);
            double x00 = StrictMath.min(x1, x2) - 1.0E-6;
            double x01 = StrictMath.max(x1, x2) + 1.0E-6;
            double y00 = StrictMath.min(y1, y2) - 1.0E-6;
            double y01 = StrictMath.max(y1, y2) + 1.0E-6;
            double x10 = StrictMath.min(shapeX[p], shapeX[p + 1]) - 1.0E-6;
            double x11 = StrictMath.max(shapeX[p], shapeX[p + 1]) + 1.0E-6;
            double y10 = StrictMath.min(shapeY[p], shapeY[p + 1]) - 1.0E-6;
            double y11 = StrictMath.max(shapeY[p], shapeY[p + 1]) + 1.0E-6;
            boolean bl = touching = x00 == s && y00 == t || x01 == s && y01 == t || x10 == s && y10 == t || x11 == s && y11 == t;
            if (touching || x00 > s || x01 < s || y00 > t || y01 < t || x10 > s || x11 < s || y10 > t || y11 < t) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<double[]> circleToPoly(double lon, double lat, double radiusMeters) {
        int sides = 25;
        ArrayList<double[]> geometry = new ArrayList<double[]>();
        double[] lons = new double[25];
        double[] lats = new double[25];
        double[] pt = new double[2];
        int sidesLen = 24;
        for (int i = 0; i < 24; ++i) {
            double angle = i * 360 / 25;
            pt = GeoProjectionUtils.pointFromLonLatBearing(lon, lat, angle, radiusMeters, pt);
            lons[i] = pt[0];
            lats[i] = pt[1];
        }
        lons[24] = lons[0];
        lats[24] = lats[0];
        geometry.add(lons);
        geometry.add(lats);
        return geometry;
    }

    public static boolean rectWithinPoly(double rMinX, double rMinY, double rMaxX, double rMaxY, double[] shapeX, double[] shapeY, double sMinX, double sMinY, double sMaxX, double sMaxY) {
        return !GeoUtils.rectCrossesPoly(rMinX, rMinY, rMaxX, rMaxY, shapeX, shapeY, sMinX, sMinY, sMaxX, sMaxY) && GeoUtils.pointInPolygon(shapeX, shapeY, rMinY, rMinX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMinY, rMaxX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMaxX) && GeoUtils.pointInPolygon(shapeX, shapeY, rMaxY, rMinX);
    }

    private static boolean rectAnyCornersOutsideCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMinX) * 1000.0 > radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMinX) * 1000.0 > radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMaxX) * 1000.0 > radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMaxX) * 1000.0 > radiusMeters;
    }

    private static boolean rectAnyCornersInCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMinX) * 1000.0 <= radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMinX) * 1000.0 <= radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMaxY, (double)rMaxX) * 1000.0 <= radiusMeters || SloppyMath.haversin((double)centerLat, (double)centerLon, (double)rMinY, (double)rMaxX) * 1000.0 <= radiusMeters;
    }

    public static boolean rectWithinCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return !GeoUtils.rectAnyCornersOutsideCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters);
    }

    public static boolean rectCrossesCircle(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        return GeoUtils.rectAnyCornersInCircle(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters) || GeoUtils.isClosestPointOnRectWithinRange(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, radiusMeters);
    }

    private static boolean isClosestPointOnRectWithinRange(double rMinX, double rMinY, double rMaxX, double rMaxY, double centerLon, double centerLat, double radiusMeters) {
        double[] closestPt = new double[]{0.0, 0.0};
        GeoDistanceUtils.closestPointOnBBox(rMinX, rMinY, rMaxX, rMaxY, centerLon, centerLat, closestPt);
        return SloppyMath.haversin((double)centerLat, (double)centerLon, (double)closestPt[1], (double)closestPt[0]) * 1000.0 <= radiusMeters;
    }

    public static GeoRect circleToBBox(double centerLon, double centerLat, double radiusMeters) {
        double maxLon;
        double minLon;
        double radLat = StrictMath.toRadians(centerLat);
        double radLon = StrictMath.toRadians(centerLon);
        double radDistance = radiusMeters / 6378137.0;
        double minLat = radLat - radDistance;
        double maxLat = radLat + radDistance;
        if (minLat > GeoProjectionUtils.MIN_LAT_RADIANS && maxLat < GeoProjectionUtils.MAX_LAT_RADIANS) {
            double deltaLon = StrictMath.asin(StrictMath.sin(radDistance) / StrictMath.cos(radLat));
            minLon = radLon - deltaLon;
            if (minLon < GeoProjectionUtils.MIN_LON_RADIANS) {
                minLon += Math.PI * 2;
            }
            if ((maxLon = radLon + deltaLon) > GeoProjectionUtils.MAX_LON_RADIANS) {
                maxLon -= Math.PI * 2;
            }
        } else {
            minLat = StrictMath.max(minLat, GeoProjectionUtils.MIN_LAT_RADIANS);
            maxLat = StrictMath.min(maxLat, GeoProjectionUtils.MAX_LAT_RADIANS);
            minLon = GeoProjectionUtils.MIN_LON_RADIANS;
            maxLon = GeoProjectionUtils.MAX_LON_RADIANS;
        }
        return new GeoRect(StrictMath.toDegrees(minLon), StrictMath.toDegrees(maxLon), StrictMath.toDegrees(minLat), StrictMath.toDegrees(maxLat));
    }

    public static GeoRect polyToBBox(double[] polyLons, double[] polyLats) {
        if (polyLons.length != polyLats.length) {
            throw new IllegalArgumentException("polyLons and polyLats must be equal length");
        }
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < polyLats.length; ++i) {
            if (!GeoUtils.isValidLon(polyLons[i])) {
                throw new IllegalArgumentException("invalid polyLons[" + i + "]=" + polyLons[i]);
            }
            if (!GeoUtils.isValidLat(polyLats[i])) {
                throw new IllegalArgumentException("invalid polyLats[" + i + "]=" + polyLats[i]);
            }
            minLon = Math.min(polyLons[i], minLon);
            maxLon = Math.max(polyLons[i], maxLon);
            minLat = Math.min(polyLats[i], minLat);
            maxLat = Math.max(polyLats[i], maxLat);
        }
        return new GeoRect(GeoUtils.unscaleLon(GeoUtils.scaleLon(minLon)), GeoUtils.unscaleLon(GeoUtils.scaleLon(maxLon)), GeoUtils.unscaleLat(GeoUtils.scaleLat(minLat)), GeoUtils.unscaleLat(GeoUtils.scaleLat(maxLat)));
    }

    public static boolean isValidLat(double lat) {
        return !Double.isNaN(lat) && lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return !Double.isNaN(lon) && lon >= -180.0 && lon <= 180.0;
    }
}

