/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.entitystore.FieldMapper;
import com.netflix.astyanax.entitystore.SimpleCompositeBuilder;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.query.ColumnPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;

public class CompositeColumnEntityMapper {
    private final Class<?> clazz;
    private List<FieldMapper<?>> components = Lists.newArrayList();
    private Set<String> validNames = Sets.newHashSet();
    private FieldMapper<?> valueMapper;
    private int bufferSize = 64;
    private final Field containerField;

    public CompositeColumnEntityMapper(Field field) {
        Field[] declaredFields;
        ParameterizedType containerEntityType = (ParameterizedType)field.getGenericType();
        this.clazz = (Class)containerEntityType.getActualTypeArguments()[0];
        this.containerField = field;
        this.containerField.setAccessible(true);
        for (Field f : declaredFields = this.clazz.getDeclaredFields()) {
            javax.persistence.Column columnAnnotation = f.getAnnotation(javax.persistence.Column.class);
            if (columnAnnotation == null) continue;
            f.setAccessible(true);
            FieldMapper fieldMapper = new FieldMapper(f);
            this.components.add(fieldMapper);
            this.validNames.add(fieldMapper.getName());
        }
        this.valueMapper = this.components.remove(this.components.size() - 1);
    }

    public void fillMutationBatch(ColumnListMutation<ByteBuffer> clm, Object entity) throws IllegalArgumentException, IllegalAccessException {
        List list = (List)this.containerField.get(entity);
        if (list != null) {
            for (Object element : list) {
                this.fillColumnMutation(clm, element);
            }
        }
    }

    public void fillMutationBatchForDelete(ColumnListMutation<ByteBuffer> clm, Object entity) throws IllegalArgumentException, IllegalAccessException {
        List list = (List)this.containerField.get(entity);
        if (list == null) {
            clm.delete();
        } else {
            for (Object element : list) {
                clm.deleteColumn((Object)this.toColumnName(element));
            }
        }
    }

    public void fillColumnMutation(ColumnListMutation<ByteBuffer> clm, Object entity) {
        try {
            ByteBuffer columnName = this.toColumnName(entity);
            ByteBuffer value = this.valueMapper.toByteBuffer(entity);
            clm.putColumn((Object)columnName, value);
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    public ByteBuffer toColumnName(Object obj) {
        SimpleCompositeBuilder composite = new SimpleCompositeBuilder(this.bufferSize, Equality.EQUAL);
        for (FieldMapper<?> mapper : this.components) {
            try {
                composite.addWithoutControl(mapper.toByteBuffer(obj));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return composite.get();
    }

    public boolean setField(Object entity, ColumnList<ByteBuffer> columns) throws Exception {
        List<Object> list = this.getOrCreateField(entity);
        for (Column c : columns) {
            list.add(this.fromColumn((Column<ByteBuffer>)c));
        }
        return true;
    }

    public boolean setFieldFromCql(Object entity, ColumnList<ByteBuffer> columns) throws Exception {
        List<Object> list = this.getOrCreateField(entity);
        list.add(this.fromCqlColumns(columns));
        return true;
    }

    private List<Object> getOrCreateField(Object entity) throws IllegalArgumentException, IllegalAccessException {
        List list = (List)this.containerField.get(entity);
        if (list == null) {
            list = Lists.newArrayList();
            this.containerField.set(entity, list);
        }
        return list;
    }

    public Object fromColumn(Column<ByteBuffer> c) {
        try {
            Object entity = this.clazz.newInstance();
            this.setEntityFieldsFromColumnName(entity, c.getRawName().duplicate());
            this.valueMapper.setField(entity, c.getByteBufferValue().duplicate());
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    public Object fromCqlColumns(ColumnList<ByteBuffer> c) {
        try {
            Object entity = this.clazz.newInstance();
            Iterator columnIter = c.iterator();
            columnIter.next();
            for (FieldMapper<?> component : this.components) {
                component.setField(entity, ((Column)columnIter.next()).getByteBufferValue());
            }
            this.valueMapper.setField(entity, ((Column)columnIter.next()).getByteBufferValue());
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    public void setEntityFieldsFromColumnName(Object entity, ByteBuffer columnName) throws IllegalArgumentException, IllegalAccessException {
        for (FieldMapper<?> component : this.components) {
            ByteBuffer data = CompositeColumnEntityMapper.getWithShortLength(columnName);
            if (data != null) {
                byte end_of_component;
                if (data.remaining() > 0) {
                    component.setField(entity, data);
                }
                if ((end_of_component = columnName.get()) == Equality.EQUAL.toByte()) continue;
                throw new RuntimeException("Invalid composite column.  Expected END_OF_COMPONENT.");
            }
            throw new RuntimeException("Missing component data in composite type");
        }
    }

    public String getComparatorType() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeType(");
        sb.append(StringUtils.join((Collection)Collections2.transform(this.components, (Function)new Function<FieldMapper<?>, String>(){

            public String apply(FieldMapper<?> input) {
                return input.serializer.getComparatorType().getClassName();
            }
        }), (String)","));
        sb.append(")");
        return sb.toString();
    }

    public static int getShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    public static ByteBuffer getWithShortLength(ByteBuffer bb) {
        int length = CompositeColumnEntityMapper.getShortLength(bb);
        return CompositeColumnEntityMapper.getBytes(bb, length);
    }

    public static ByteBuffer getBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    public String getValueType() {
        return this.valueMapper.getSerializer().getComparatorType().getClassName();
    }

    public ByteBuffer[] getQueryEndpoints(Collection<ColumnPredicate> predicates) {
        ArrayListMultimap lookup = ArrayListMultimap.create();
        for (ColumnPredicate predicate : predicates) {
            Preconditions.checkArgument((boolean)this.validNames.contains(predicate.getName()), (Object)("Field '" + predicate.getName() + "' does not exist in the entity " + this.clazz.getCanonicalName()));
            lookup.put((Object)predicate.getName(), (Object)predicate);
        }
        SimpleCompositeBuilder start = new SimpleCompositeBuilder(this.bufferSize, Equality.GREATER_THAN_EQUALS);
        SimpleCompositeBuilder end = new SimpleCompositeBuilder(this.bufferSize, Equality.LESS_THAN_EQUALS);
        for (FieldMapper<?> mapper : this.components) {
            for (ColumnPredicate p : lookup.get((Object)mapper.getName())) {
                this.applyPredicate(mapper, start, end, p);
            }
        }
        return new ByteBuffer[]{start.get(), end.get()};
    }

    private void applyPredicate(FieldMapper<?> mapper, SimpleCompositeBuilder start, SimpleCompositeBuilder end, ColumnPredicate predicate) {
        ByteBuffer bb = mapper.valueToByteBuffer(predicate.getValue());
        switch (predicate.getOp()) {
            case EQUAL: {
                start.addWithoutControl(bb);
                end.addWithoutControl(bb);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUALS: {
                if (mapper.isAscending()) {
                    start.add(bb, predicate.getOp());
                    break;
                }
                end.add(bb, predicate.getOp());
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_EQUALS: {
                if (mapper.isAscending()) {
                    end.add(bb, predicate.getOp());
                    break;
                }
                start.add(bb, predicate.getOp());
            }
        }
    }
}

