/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.contrib.dualwrites.FailedWritesLogger;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFailedWritesLogger
implements FailedWritesLogger {
    private static final Logger Logger = LoggerFactory.getLogger(AsyncFailedWritesLogger.class);
    private static final int DEFAULT_QUEUE_SIZE = 1000;
    private final FailedWritesLogger actualWriter;
    private ExecutorService threadPool;
    private final LinkedBlockingQueue<WriteMetadata> taskQueue;
    private final AtomicBoolean stop = new AtomicBoolean(false);

    public AsyncFailedWritesLogger(FailedWritesLogger writer) {
        this(writer, 1000);
    }

    public AsyncFailedWritesLogger(FailedWritesLogger writer, int queueSize) {
        this.actualWriter = writer;
        this.taskQueue = new LinkedBlockingQueue(queueSize);
    }

    @Override
    public void logFailedWrite(WriteMetadata failedWrite) {
        boolean success = this.taskQueue.offer(failedWrite);
        if (!success) {
            Logger.error("Async failed writes logger is backed up and is dropping failed writes " + failedWrite);
        }
    }

    @Override
    public void init() {
        if (this.stop.get()) {
            Logger.error("Will not start async logger, already stopped");
            return;
        }
        if (this.threadPool == null) {
            this.threadPool = Executors.newScheduledThreadPool(1);
        }
        this.threadPool.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Logger.info("Async failed writes logger starting..");
                while (!AsyncFailedWritesLogger.this.stop.get() && !Thread.currentThread().isInterrupted()) {
                    try {
                        WriteMetadata writeMD = (WriteMetadata)AsyncFailedWritesLogger.this.taskQueue.take();
                        try {
                            AsyncFailedWritesLogger.this.actualWriter.logFailedWrite(writeMD);
                        }
                        catch (Exception e) {
                            Logger.error("Failed to log failed write asynchronously", (Throwable)e);
                        }
                    }
                    catch (InterruptedException e) {
                        AsyncFailedWritesLogger.this.stop.set(true);
                    }
                }
                Logger.info("Async failed writes logger exiting..");
                return null;
            }
        });
    }

    @Override
    public void shutdown() {
        this.stop.set(true);
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }
}

