/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;

public class DualWritesColumnMutation
implements ColumnMutation {
    private final ColumnMutation primary;
    private final ColumnMutation secondary;
    private final DualWritesStrategy executionStrategy;
    private final Collection<WriteMetadata> writeMetadata;

    public DualWritesColumnMutation(WriteMetadata writeMD, ColumnMutation primaryClm, ColumnMutation secondaryClm, DualWritesStrategy execStrategy) {
        this.writeMetadata = Collections.singletonList(writeMD);
        this.primary = primaryClm;
        this.secondary = secondaryClm;
        this.executionStrategy = execStrategy;
    }

    public ColumnMutation setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.primary.setConsistencyLevel(consistencyLevel);
        this.secondary.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public ColumnMutation withRetryPolicy(RetryPolicy retry) {
        this.primary.withRetryPolicy(retry);
        this.secondary.withRetryPolicy(retry);
        return this;
    }

    public ColumnMutation withTimestamp(long timestamp) {
        this.primary.withTimestamp(timestamp);
        this.secondary.withTimestamp(timestamp);
        return this;
    }

    public Execution<Void> putValue(String value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(byte[] value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(byte value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(short value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(int value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(long value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(boolean value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(ByteBuffer value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(Date value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(float value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(double value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putValue(UUID value, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, ttl);
        Execution ex2 = this.secondary.putValue(value, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public <T> Execution<Void> putValue(T value, Serializer<T> serializer, Integer ttl) {
        Execution ex1 = this.primary.putValue(value, serializer, ttl);
        Execution ex2 = this.secondary.putValue(value, serializer, ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> putEmptyColumn(Integer ttl) {
        Execution ex1 = this.primary.putEmptyColumn(ttl);
        Execution ex2 = this.secondary.putEmptyColumn(ttl);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> incrementCounterColumn(long amount) {
        Execution ex1 = this.primary.incrementCounterColumn(amount);
        Execution ex2 = this.secondary.incrementCounterColumn(amount);
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> deleteColumn() {
        Execution ex1 = this.primary.deleteColumn();
        Execution ex2 = this.secondary.deleteColumn();
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }

    public Execution<Void> deleteCounterColumn() {
        Execution ex1 = this.primary.deleteCounterColumn();
        Execution ex2 = this.secondary.deleteCounterColumn();
        return this.executionStrategy.wrapExecutions(ex1, ex2, this.writeMetadata);
    }
}

