/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.eureka;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.MyDataCenterInstanceConfig;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaBasedHostSupplier
implements Supplier<List<Host>> {
    private static final Logger LOG = LoggerFactory.getLogger(EurekaBasedHostSupplier.class);
    private final String applicationName;

    public EurekaBasedHostSupplier(String applicationName) {
        this.applicationName = applicationName.toUpperCase();
        DiscoveryManager.getInstance().initComponent((EurekaInstanceConfig)new MyDataCenterInstanceConfig(), (EurekaClientConfig)new DefaultEurekaClientConfig());
    }

    public List<Host> get() {
        DiscoveryClient discoveryClient = DiscoveryManager.getInstance().getDiscoveryClient();
        if (discoveryClient == null) {
            LOG.error("Error getting discovery client");
            throw new RuntimeException("Failed to create discovery client");
        }
        Application app = discoveryClient.getApplication(this.applicationName);
        ArrayList hosts = Lists.newArrayList();
        if (app == null) {
            return hosts;
        }
        List ins = app.getInstances();
        if (ins == null || ins.isEmpty()) {
            return hosts;
        }
        hosts = Lists.newArrayList((Iterable)Collections2.transform((Collection)Collections2.filter((Collection)ins, (Predicate)new Predicate<InstanceInfo>(){

            public boolean apply(InstanceInfo input) {
                return input.getStatus() == InstanceInfo.InstanceStatus.UP;
            }
        }), (Function)new Function<InstanceInfo, Host>(){

            public Host apply(InstanceInfo info) {
                String[] parts = StringUtils.split((String)StringUtils.split((String)info.getHostName(), (String)".")[0], (char)'-');
                Host host = new Host(info.getHostName(), info.getPort()).addAlternateIpAddress(StringUtils.join((Object[])new String[]{parts[1], parts[2], parts[3], parts[4]}, (String)".")).addAlternateIpAddress(info.getIPAddr()).setId(info.getId());
                try {
                    if (info.getDataCenterInfo() instanceof AmazonInfo) {
                        AmazonInfo amazonInfo = (AmazonInfo)info.getDataCenterInfo();
                        host.setRack(amazonInfo.get(AmazonInfo.MetaDataKey.availabilityZone));
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error getting rack for host " + host.getName(), t);
                }
                return host;
            }
        }));
        return hosts;
    }
}

