/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.ICountableColumnIterator;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.BytesReadTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
ICountableColumnIterator {
    private static final Logger logger = LoggerFactory.getLogger(SSTableIdentityIterator.class);
    private final DecoratedKey key;
    private final DataInput input;
    private final long dataStart;
    public final long dataSize;
    public final IColumnSerializer.Flag flag;
    private final ColumnFamily columnFamily;
    private final int columnCount;
    private final long columnPosition;
    private final OnDiskAtom.Serializer atomSerializer;
    private final Descriptor.Version dataVersion;
    private final BytesReadTracker inputWithTracker;
    private final int expireBefore;
    private final boolean validateColumns;
    private final String filename;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataStart, long dataSize) {
        this(sstable, file, key, dataStart, dataSize, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, long dataStart, long dataSize, boolean checkData) {
        this(sstable.metadata, file, file.getPath(), key, dataStart, dataSize, checkData, sstable, IColumnSerializer.Flag.LOCAL);
    }

    public SSTableIdentityIterator(CFMetaData metadata, DataInput file, String filename, DecoratedKey key, long dataStart, long dataSize, IColumnSerializer.Flag flag) {
        this(metadata, file, filename, key, dataStart, dataSize, false, null, flag);
    }

    private SSTableIdentityIterator(CFMetaData metadata, DataInput input, String filename, DecoratedKey key, long dataStart, long dataSize, boolean checkData, SSTableReader sstable, IColumnSerializer.Flag flag) {
        assert (!checkData || sstable != null);
        this.input = input;
        this.filename = filename;
        this.inputWithTracker = new BytesReadTracker(input);
        this.key = key;
        this.dataStart = dataStart;
        this.dataSize = dataSize;
        this.expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.flag = flag;
        this.validateColumns = checkData;
        this.dataVersion = sstable == null ? Descriptor.Version.CURRENT : sstable.descriptor.version;
        try {
            if (input instanceof RandomAccessReader) {
                RandomAccessReader file = (RandomAccessReader)input;
                file.seek(this.dataStart);
                if (dataStart + dataSize > file.length()) {
                    throw new IOException(String.format("dataSize of %s starting at %s would be larger than file %s length %s", dataSize, dataStart, file.getPath(), file.length()));
                }
                if (checkData && !this.dataVersion.hasPromotedIndexes) {
                    try {
                        IndexHelper.skipBloomFilter(file);
                    }
                    catch (Exception e) {
                        if (e instanceof EOFException) {
                            throw (EOFException)e;
                        }
                        logger.debug("Invalid bloom filter in {}; will rebuild it", (Object)sstable);
                    }
                    try {
                        IndexHelper.deserializeIndex(file);
                    }
                    catch (Exception e) {
                        logger.debug("Invalid row summary in {}; will rebuild it", (Object)sstable);
                    }
                    file.seek(this.dataStart);
                    this.inputWithTracker.reset(0L);
                }
            }
            if (sstable != null && !this.dataVersion.hasPromotedIndexes) {
                IndexHelper.skipBloomFilter(this.inputWithTracker);
                IndexHelper.skipIndex(this.inputWithTracker);
            }
            this.columnFamily = ColumnFamily.create(metadata);
            this.columnFamily.delete(DeletionTime.serializer.deserialize(this.inputWithTracker));
            this.atomSerializer = this.columnFamily.getOnDiskSerializer();
            this.columnCount = this.inputWithTracker.readInt();
            this.columnPosition = dataStart + this.inputWithTracker.getBytesRead();
        }
        catch (IOException e) {
            if (sstable != null) {
                sstable.markSuspect();
            }
            throw new CorruptSSTableException((Exception)e, filename);
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        return this.inputWithTracker.getBytesRead() < this.dataSize;
    }

    @Override
    public OnDiskAtom next() {
        try {
            OnDiskAtom atom = this.atomSerializer.deserializeFromSSTable(this.inputWithTracker, this.flag, this.expireBefore, this.dataVersion);
            if (this.validateColumns) {
                atom.validateFields(this.columnFamily.metadata());
            }
            return atom;
        }
        catch (IOException e) {
            throw new CorruptSSTableException((Exception)e, this.filename);
        }
        catch (MarshalException me) {
            throw new CorruptSSTableException((Exception)me, this.filename);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public String getPath() {
        if (this.input instanceof RandomAccessReader) {
            RandomAccessReader file = (RandomAccessReader)this.input;
            return file.getPath();
        }
        throw new UnsupportedOperationException();
    }

    public ColumnFamily getColumnFamilyWithColumns(ISortedColumns.Factory containerFactory) throws IOException {
        assert (this.inputWithTracker.getBytesRead() == this.headerSize());
        ColumnFamily cf = this.columnFamily.cloneMeShallow(containerFactory, false);
        ColumnFamily.serializer.deserializeColumnsFromSSTable(this.inputWithTracker, cf, this.columnCount, this.flag, this.expireBefore, this.dataVersion);
        if (this.validateColumns) {
            try {
                cf.validateColumnFields();
            }
            catch (MarshalException e) {
                throw new RuntimeException("Error validating row " + this.key, e);
            }
        }
        return cf;
    }

    private long headerSize() {
        return this.columnPosition - this.dataStart;
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }

    @Override
    public void reset() {
        if (!(this.input instanceof RandomAccessReader)) {
            throw new UnsupportedOperationException();
        }
        RandomAccessReader file = (RandomAccessReader)this.input;
        file.seek(this.columnPosition);
        this.inputWithTracker.reset(this.headerSize());
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }
}

