/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.examples;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.AstyanaxContext;
import com.netflix.astyanax.AstyanaxTypeFactory;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.ConnectionPoolConfiguration;
import com.netflix.astyanax.connectionpool.ConnectionPoolMonitor;
import com.netflix.astyanax.connectionpool.NodeDiscoveryType;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.impl.ConnectionPoolConfigurationImpl;
import com.netflix.astyanax.connectionpool.impl.CountingConnectionPoolMonitor;
import com.netflix.astyanax.impl.AstyanaxConfigurationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftFamilyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstCQLClient {
    private static final Logger logger = LoggerFactory.getLogger(AstCQLClient.class);
    private AstyanaxContext<Keyspace> context;
    private Keyspace keyspace;
    private ColumnFamily<Integer, String> EMP_CF;
    private static final String EMP_CF_NAME = "employees1";
    private static final String INSERT_STATEMENT = String.format("INSERT INTO %s (%s, %s, %s, %s) VALUES (?, ?, ?, ?);", "employees1", "empid", "deptid", "first_name", "last_name");
    private static final String CREATE_STATEMENT = String.format("CREATE TABLE %s (%s int, %s int, %s varchar, %s varchar, PRIMARY KEY (%s, %s))", "employees1", "empid", "deptid", "first_name", "last_name", "empid", "deptid");

    public void init() {
        logger.debug("init()");
        this.context = new AstyanaxContext.Builder().forCluster("Test Cluster").forKeyspace("test1").withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setDiscoveryType(NodeDiscoveryType.RING_DESCRIBE)).withConnectionPoolConfiguration((ConnectionPoolConfiguration)new ConnectionPoolConfigurationImpl("MyConnectionPool").setPort(9160).setMaxConnsPerHost(1).setSeeds("127.0.0.1:9160")).withAstyanaxConfiguration((AstyanaxConfiguration)new AstyanaxConfigurationImpl().setCqlVersion("3.0.0").setTargetCassandraVersion("1.2")).withConnectionPoolMonitor((ConnectionPoolMonitor)new CountingConnectionPoolMonitor()).buildKeyspace((AstyanaxTypeFactory)ThriftFamilyFactory.getInstance());
        this.context.start();
        this.keyspace = (Keyspace)this.context.getEntity();
        this.EMP_CF = ColumnFamily.newColumnFamily((String)EMP_CF_NAME, (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get());
    }

    public void insert(int empId, int deptId, String firstName, String lastName) {
        try {
            OperationResult result = this.keyspace.prepareQuery(this.EMP_CF).withCql(INSERT_STATEMENT).asPreparedStatement().withIntegerValue(Integer.valueOf(empId)).withIntegerValue(Integer.valueOf(deptId)).withStringValue(firstName).withStringValue(lastName).execute();
        }
        catch (ConnectionException e) {
            logger.error("failed to write data to C*", (Throwable)e);
            throw new RuntimeException("failed to write data to C*", e);
        }
        logger.debug("insert ok");
    }

    public void insertDynamicProperties(int id, String[] ... entries) {
        MutationBatch m = this.keyspace.prepareMutationBatch();
        ColumnListMutation clm = m.withRow(this.EMP_CF, (Object)id);
        for (String[] kv : entries) {
            clm.putColumn((Object)kv[0], kv[1], null);
        }
        try {
            OperationResult result = m.execute();
        }
        catch (ConnectionException e) {
            logger.error("failed to write data to C*", (Throwable)e);
            throw new RuntimeException("failed to write data to C*", e);
        }
        logger.debug("insert ok");
    }

    public void createCF() {
        logger.debug("CQL: " + CREATE_STATEMENT);
        try {
            OperationResult result = this.keyspace.prepareQuery(this.EMP_CF).withCql(CREATE_STATEMENT).execute();
        }
        catch (ConnectionException e) {
            logger.error("failed to create CF", (Throwable)e);
            throw new RuntimeException("failed to create CF", e);
        }
    }

    public void read(int empId) {
        logger.debug("read()");
        try {
            OperationResult result = this.keyspace.prepareQuery(this.EMP_CF).withCql(String.format("SELECT * FROM %s WHERE %s=%d;", EMP_CF_NAME, "empid", empId)).execute();
            for (Row row : ((CqlResult)result.getResult()).getRows()) {
                logger.debug("row: " + row.getKey() + "," + row);
                ColumnList cols = row.getColumns();
                logger.debug("emp");
                logger.debug("- emp id: " + cols.getIntegerValue((Object)"empid", null));
                logger.debug("- dept: " + cols.getIntegerValue((Object)"deptid", null));
                logger.debug("- firstName: " + cols.getStringValue((Object)"first_name", null));
                logger.debug("- lastName: " + cols.getStringValue((Object)"last_name", null));
            }
        }
        catch (ConnectionException e) {
            logger.error("failed to read from C*", (Throwable)e);
            throw new RuntimeException("failed to read from C*", e);
        }
    }

    public static void main(String[] args) {
        logger.debug("main");
        AstCQLClient c = new AstCQLClient();
        c.init();
        c.insert(222, 333, "Eric", "Cartman");
        c.read(222);
    }
}

