/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.ddl.ColumnFamilyDefinition;
import com.netflix.astyanax.ddl.KeyspaceDefinition;
import com.netflix.astyanax.impl.PreparedIndexExpressionImpl;
import com.netflix.astyanax.model.ColumnType;
import com.netflix.astyanax.query.PreparedIndexExpression;
import com.netflix.astyanax.serializers.ByteBufferSerializer;

public class ColumnFamily<K, C>
implements Comparable<ColumnFamily<K, C>> {
    private final String columnFamilyName;
    private final Serializer<K> keySerializer;
    private final Serializer<C> columnSerializer;
    private final Serializer<?> defaultValueSerializer;
    private final ColumnType type;
    private ColumnFamilyDefinition cfDef;
    private String keyAlias = "key";

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, ColumnType type) {
        this.columnFamilyName = columnFamilyName;
        this.keySerializer = keySerializer;
        this.columnSerializer = columnSerializer;
        this.defaultValueSerializer = ByteBufferSerializer.get();
        this.type = type;
    }

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer) {
        this(columnFamilyName, keySerializer, columnSerializer, ByteBufferSerializer.get());
    }

    public ColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, Serializer<?> defaultValueSerializer) {
        this.columnFamilyName = columnFamilyName;
        this.keySerializer = keySerializer;
        this.columnSerializer = columnSerializer;
        this.defaultValueSerializer = defaultValueSerializer;
        this.type = ColumnType.STANDARD;
    }

    public String getName() {
        return this.columnFamilyName;
    }

    public Serializer<C> getColumnSerializer() {
        return this.columnSerializer;
    }

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<?> getDefaultValueSerializer() {
        return this.defaultValueSerializer;
    }

    public ColumnType getType() {
        return this.type;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public PreparedIndexExpression<K, C> newIndexClause() {
        return new PreparedIndexExpressionImpl(this.columnSerializer);
    }

    public static <K, C> ColumnFamily<K, C> newColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer) {
        return new ColumnFamily<K, C>(columnFamilyName, keySerializer, columnSerializer);
    }

    public static <K, C> ColumnFamily<K, C> newColumnFamily(String columnFamilyName, Serializer<K> keySerializer, Serializer<C> columnSerializer, Serializer<?> defaultSerializer) {
        return new ColumnFamily<K, C>(columnFamilyName, keySerializer, columnSerializer, defaultSerializer);
    }

    @Override
    public int compareTo(ColumnFamily<K, C> other) {
        return this.getName().compareTo(other.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnFamily)) {
            return false;
        }
        ColumnFamily other = (ColumnFamily)obj;
        return this.getName() == null ? other.getName() == null : this.getName().equals(other.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    public boolean inThriftMode() {
        return true;
    }

    public ColumnFamilyDefinition describe(Keyspace keyspace) throws ConnectionException {
        KeyspaceDefinition ksDef = keyspace.describeKeyspace();
        this.cfDef = ksDef.getColumnFamily(this.getName());
        return this.cfDef;
    }

    public ColumnFamilyDefinition getColumnFamilyDefinition() {
        return this.cfDef;
    }
}

