/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.impl.AckingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingAckingQueue
implements AckingQueue {
    private LinkedBlockingQueue<MutationBatch> queue = Queues.newLinkedBlockingQueue();
    private ConcurrentMap<MutationBatch, Boolean> busy = Maps.newConcurrentMap();

    @Override
    public MutationBatch getNextMutation(long timeout, TimeUnit unit) throws InterruptedException {
        MutationBatch mutation = this.queue.poll(timeout, unit);
        if (mutation != null) {
            this.busy.put(mutation, true);
        }
        return mutation;
    }

    @Override
    public void pushMutation(MutationBatch m) throws Exception {
        this.queue.put(m);
    }

    @Override
    public void ackMutation(MutationBatch m) throws Exception {
        this.busy.remove(m);
    }

    @Override
    public void repushMutation(MutationBatch m) throws Exception {
        this.busy.remove(m);
        this.pushMutation(m);
    }

    @Override
    public int size() {
        return this.queue.size();
    }
}

