/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.util;

import com.netflix.astyanax.util.RecordReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.csv.CSVParser;

public class CsvColumnReader
implements RecordReader {
    private CSVParser parser;
    private boolean hasHeaderLine = true;

    public CsvColumnReader(Reader reader) {
        this.parser = new CSVParser(reader);
    }

    public CsvColumnReader setHasHeaderLine(boolean flag) {
        this.hasHeaderLine = flag;
        return this;
    }

    @Override
    public void start() throws IOException {
        if (this.hasHeaderLine) {
            this.parser.getLine();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Pair<String, String>> next() throws IOException {
        String[] row = this.parser.getLine();
        if (null == row) {
            return null;
        }
        ArrayList<Pair<String, String>> columns = new ArrayList<Pair<String, String>>();
        columns.add(Pair.create((Object)"key", (Object)row[0]));
        if (row.length == 3) {
            columns.add((Pair<String, String>)Pair.create((Object)row[1], (Object)row[2]));
        }
        return columns;
    }
}

