/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;

public class ThriftRowsListImpl<K, C>
implements Rows<K, C> {
    private List<Row<K, C>> rows;
    private Map<K, Row<K, C>> lookup;

    public ThriftRowsListImpl(Map<ByteBuffer, List<ColumnOrSuperColumn>> rows, Serializer<K> keySer, Serializer<C> colSer) {
        this.rows = Lists.newArrayListWithCapacity((int)rows.size());
        this.lookup = Maps.newLinkedHashMap();
        for (Map.Entry<ByteBuffer, List<ColumnOrSuperColumn>> row : rows.entrySet()) {
            ThriftRowImpl<Object, C> thriftRow = new ThriftRowImpl<Object, C>(keySer.fromByteBuffer(row.getKey().duplicate()), row.getKey(), new ThriftColumnOrSuperColumnListImpl<C>(row.getValue(), colSer));
            this.rows.add(thriftRow);
            this.lookup.put(thriftRow.getKey(), thriftRow);
        }
    }

    public Iterator<Row<K, C>> iterator() {
        return this.rows.iterator();
    }

    public Row<K, C> getRow(K key) {
        return this.lookup.get(key);
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public Row<K, C> getRowByIndex(int i) {
        return this.rows.get(i);
    }

    public Collection<K> getKeys() {
        return this.lookup.keySet();
    }
}

