/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.netflix.appinfo.DataCenterInfo;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonInfo
implements DataCenterInfo {
    private Map<String, String> metadata = new HashMap<String, String>();
    private static DynamicBooleanProperty shouldLogAWSMetadataError;
    private static DynamicIntProperty awsMetaDataReadTimeout;
    private static DynamicIntProperty awsMetaDataConnectTimeout;
    private static DynamicIntProperty awsMetaDataRetries;

    @Override
    public DataCenterInfo.Name getName() {
        return DataCenterInfo.Name.Amazon;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadataMap) {
        this.metadata = metadataMap;
    }

    public String get(MetaDataKey key) {
        return this.metadata.get(key.getName());
    }

    public static final class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private static final int SLEEP_TIME_MS = 100;
        private static final String AWS_API_VERSION = "latest";
        private static final String AWS_METADATA_URL = "http://169.254.169.254/latest/meta-data/";
        @XStreamOmitField
        private AmazonInfo result = new AmazonInfo();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder addMetadata(MetaDataKey key, String value) {
            this.result.metadata.put(key.getName(), value);
            return this;
        }

        public AmazonInfo build() {
            return this.result;
        }

        public AmazonInfo autoBuild(String namespace) {
            this.initProperties(namespace);
            for (MetaDataKey key : MetaDataKey.values()) {
                int numOfRetries = awsMetaDataRetries.get();
                while (numOfRetries-- > 0) {
                    try {
                        URL url = new URL(AWS_METADATA_URL + key.getPath() + key.getName());
                        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
                        uc.setConnectTimeout(awsMetaDataConnectTimeout.get());
                        uc.setReadTimeout(awsMetaDataReadTimeout.get());
                        BufferedReader br = new BufferedReader(new InputStreamReader(uc.getInputStream()));
                        String value = br.readLine();
                        if (value == null) continue;
                        this.result.metadata.put(key.getName(), value);
                    }
                    catch (Throwable e) {
                        if (shouldLogAWSMetadataError.get()) {
                            logger.warn("Cannot get the value for the metadata key :" + (Object)((Object)key) + " Reason :", e);
                        }
                        if (numOfRetries < 0) continue;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {}
                    }
                }
            }
            return this.result;
        }

        private void initProperties(String namespace) {
            if (shouldLogAWSMetadataError == null) {
                shouldLogAWSMetadataError = DynamicPropertyFactory.getInstance().getBooleanProperty(namespace + "logAmazonMetadataErrors", false);
            }
            if (awsMetaDataReadTimeout == null) {
                awsMetaDataReadTimeout = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.read_timeout", 8000);
            }
            if (awsMetaDataConnectTimeout == null) {
                awsMetaDataConnectTimeout = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.connect_timeout", 3000);
            }
            if (awsMetaDataRetries == null) {
                awsMetaDataRetries = DynamicPropertyFactory.getInstance().getIntProperty(namespace + "mt.num_retries", 3);
            }
        }
    }

    public static enum MetaDataKey {
        amiId("ami-id"),
        instanceId("instance-id"),
        instanceType("instance-type"),
        localIpv4("local-ipv4"),
        availabilityZone("availability-zone", "placement/"),
        publicHostname("public-hostname"),
        publicIpv4("public-ipv4");

        private String name;
        private String path;

        private MetaDataKey(String name) {
            this(name, "");
        }

        private MetaDataKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }
    }
}

