/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.netflix.astyanax.recipes.queue.Message;
import com.netflix.astyanax.recipes.queue.MessageHistory;
import com.netflix.astyanax.recipes.queue.MessageStatus;
import org.apache.commons.lang.exception.ExceptionUtils;

public class MessageContext {
    private Message message;
    private Message nextMessage;
    private String ackMessageId;
    private MessageHistory history = new MessageHistory();

    public Message getMessage() {
        return this.message;
    }

    public MessageContext setMessage(Message message) {
        this.message = message;
        return this;
    }

    public Message getNextMessage() {
        return this.nextMessage;
    }

    public MessageContext setNextMessage(Message nextMessage) {
        this.nextMessage = nextMessage;
        return this;
    }

    public MessageHistory getHistory() {
        return this.history;
    }

    public MessageContext setException(Throwable t) {
        this.history.setStatus(MessageStatus.FAILED);
        this.history.setError(t.getMessage());
        this.history.setStackTrace(ExceptionUtils.getStackTrace((Throwable)t));
        return this;
    }

    public MessageContext setStatus(MessageStatus status) {
        this.history.setStatus(status);
        return this;
    }

    public String getAckMessageId() {
        return this.ackMessageId;
    }

    public MessageContext setAckMessageId(String ackMessageId) {
        this.ackMessageId = ackMessageId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageContext [").append("ackMessageId=" + this.ackMessageId).append(", message=" + this.message).append(", nextMessage=" + this.nextMessage).append("]");
        return sb.toString();
    }
}

