/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.RowCopier;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.reads.model.CqlColumnImpl;
import com.netflix.astyanax.cql.writes.CqlColumnListMutationImpl;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.RowQuery;
import java.util.Iterator;

public class CqlRowCopier<K, C>
implements RowCopier<K, C> {
    private boolean useOriginalTimestamp = false;
    private final RowQuery<K, C> rowQuery;
    private final ColumnFamily<K, C> cf;
    private final K rowKey;
    private final CqlKeyspaceImpl.KeyspaceContext ksContext;

    public CqlRowCopier(ColumnFamily<K, C> cf, K rowKey, RowQuery<K, C> query, CqlKeyspaceImpl.KeyspaceContext ksContext) {
        this.cf = cf;
        this.rowKey = rowKey;
        this.rowQuery = query;
        this.ksContext = ksContext;
    }

    public OperationResult<Void> execute() throws ConnectionException {
        return this.getMutationBatch().execute();
    }

    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
        return this.getMutationBatch().executeAsync();
    }

    public RowCopier<K, C> withOriginalTimestamp(boolean useTimestamp) {
        this.useOriginalTimestamp = useTimestamp;
        return this;
    }

    private MutationBatch getMutationBatch() throws ConnectionException {
        ColumnList columnList = (ColumnList)this.rowQuery.execute().getResult();
        CqlKeyspaceImpl ksImpl = new CqlKeyspaceImpl(this.ksContext);
        MutationBatch mBatch = ksImpl.prepareMutationBatch();
        CqlColumnListMutationImpl colListMutation = (CqlColumnListMutationImpl)mBatch.withRow(this.cf, this.rowKey);
        Iterator iter = columnList.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            CqlColumnImpl col = (CqlColumnImpl)iter.next();
            if (first && this.useOriginalTimestamp) {
                colListMutation.setTimestamp(col.getTimestamp());
                first = false;
            }
            colListMutation.putColumnWithGenericValue(col.getName(), col.getGenericValue(), null);
        }
        return mBatch;
    }
}

