/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.netflix.astyanax.cql.reads.CqlRowSliceQueryImpl;
import com.netflix.astyanax.cql.reads.QueryGenCache;
import com.netflix.astyanax.cql.reads.model.CqlRowSlice;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.ddl.ColumnDefinition;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class FlatTableRowSliceQueryGen {
    protected AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    protected final String keyspace;
    protected final CqlColumnFamilyDefinitionImpl cfDef;
    protected final String partitionKeyCol;
    protected final String[] allPrimayKeyCols;
    protected final List<ColumnDefinition> regularCols;
    protected static final String BIND_MARKER = "?";
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectAllColumnsForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select select = FlatTableRowSliceQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                    return select.where(QueryBuilder.in((String)FlatTableRowSliceQueryGen.this.partitionKeyCol, (Object[])rowSliceQuery.getRowSlice().getKeys().toArray()));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            return pStatement.bind(rowSliceQuery.getRowSlice().getKeys().toArray());
        }
    };
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnSetForRowKeys = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    select.column(FlatTableRowSliceQueryGen.this.partitionKeyCol);
                    for (Object col : rowSliceQuery.getColumnSlice().getColumns()) {
                        String columnName = (String)col;
                        select.column(columnName).ttl(columnName).writeTime(columnName);
                    }
                    return select.from(FlatTableRowSliceQueryGen.this.keyspace, FlatTableRowSliceQueryGen.this.cfDef.getName()).where(QueryBuilder.in((String)FlatTableRowSliceQueryGen.this.partitionKeyCol, (Object[])rowSliceQuery.getRowSlice().getKeys().toArray()));
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            ArrayList values = new ArrayList();
            values.addAll(rowSliceQuery.getRowSlice().getKeys());
            return pStatement.bind(values.toArray());
        }
    };
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectAllColumnsForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select select = FlatTableRowSliceQueryGen.this.selectAllColumnsFromKeyspaceAndCF();
                    return FlatTableRowSliceQueryGen.this.addWhereClauseForRowRange(FlatTableRowSliceQueryGen.this.partitionKeyCol, select, rowSliceQuery.getRowSlice().getRange());
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            ArrayList values = new ArrayList();
            FlatTableRowSliceQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
            return pStatement.bind(values.toArray(new Object[values.size()]));
        }
    };
    private QueryGenCache<CqlRowSliceQueryImpl<?, ?>> SelectColumnSetForRowRange = new QueryGenCache<CqlRowSliceQueryImpl<?, ?>>(this.sessionRef){

        @Override
        public Callable<RegularStatement> getQueryGen(final CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            return new Callable<RegularStatement>(){

                @Override
                public RegularStatement call() throws Exception {
                    Select.Selection select = QueryBuilder.select();
                    select.column(FlatTableRowSliceQueryGen.this.partitionKeyCol);
                    for (Object col : rowSliceQuery.getColumnSlice().getColumns()) {
                        String columnName = (String)col;
                        select.column(columnName).ttl(columnName).writeTime(columnName);
                    }
                    Select selection = select.from(FlatTableRowSliceQueryGen.this.keyspace, FlatTableRowSliceQueryGen.this.cfDef.getName());
                    Select.Where where = FlatTableRowSliceQueryGen.this.addWhereClauseForRowRange(FlatTableRowSliceQueryGen.this.partitionKeyCol, selection, rowSliceQuery.getRowSlice().getRange());
                    return where;
                }
            };
        }

        @Override
        public BoundStatement bindValues(PreparedStatement pStatement, CqlRowSliceQueryImpl<?, ?> rowSliceQuery) {
            ArrayList values = new ArrayList();
            FlatTableRowSliceQueryGen.this.bindWhereClauseForRowRange(values, rowSliceQuery.getRowSlice().getRange());
            return pStatement.bind(values.toArray());
        }
    };

    public FlatTableRowSliceQueryGen(Session session, String keyspaceName, CqlColumnFamilyDefinitionImpl cfDefinition) {
        this.keyspace = keyspaceName;
        this.cfDef = cfDefinition;
        this.sessionRef.set(session);
        this.partitionKeyCol = this.cfDef.getPartitionKeyColumnDefinition().getName();
        this.allPrimayKeyCols = this.cfDef.getAllPkColNames();
        this.regularCols = this.cfDef.getRegularColumnDefinitionList();
    }

    protected Select selectAllColumnsFromKeyspaceAndCF() {
        Select.Selection select = QueryBuilder.select();
        for (int i = 0; i < this.allPrimayKeyCols.length; ++i) {
            select.column(this.allPrimayKeyCols[i]);
        }
        for (ColumnDefinition colDef : this.regularCols) {
            String colName = colDef.getName();
            select.column(colName).ttl(colName).writeTime(colName);
        }
        return select.from(this.keyspace, this.cfDef.getName());
    }

    private Select.Where addWhereClauseForRowRange(String keyAlias, Select select, CqlRowSlice.RowRange<?> rowRange) {
        Select.Where where = null;
        boolean keyIsPresent = false;
        boolean tokenIsPresent = false;
        if (rowRange.getStartKey() != null || rowRange.getEndKey() != null) {
            keyIsPresent = true;
        }
        if (rowRange.getStartToken() != null || rowRange.getEndToken() != null) {
            tokenIsPresent = true;
        }
        if (keyIsPresent && tokenIsPresent) {
            throw new RuntimeException("Cannot provide both token and keys for range query");
        }
        if (keyIsPresent) {
            if (rowRange.getStartKey() != null && rowRange.getEndKey() != null) {
                where = select.where(QueryBuilder.gte((String)keyAlias, (Object)BIND_MARKER)).and(QueryBuilder.lte((String)keyAlias, (Object)BIND_MARKER));
            } else if (rowRange.getStartKey() != null) {
                where = select.where(QueryBuilder.gte((String)keyAlias, (Object)BIND_MARKER));
            } else if (rowRange.getEndKey() != null) {
                where = select.where(QueryBuilder.lte((String)keyAlias, (Object)BIND_MARKER));
            }
        } else if (tokenIsPresent) {
            String tokenOfKey = "token(" + keyAlias + ")";
            if (rowRange.getStartToken() != null && rowRange.getEndToken() != null) {
                where = select.where(QueryBuilder.gte((String)tokenOfKey, (Object)BIND_MARKER)).and(QueryBuilder.lte((String)tokenOfKey, (Object)BIND_MARKER));
            } else if (rowRange.getStartToken() != null) {
                where = select.where(QueryBuilder.gte((String)tokenOfKey, (Object)BIND_MARKER));
            } else if (rowRange.getEndToken() != null) {
                where = select.where(QueryBuilder.lte((String)tokenOfKey, (Object)BIND_MARKER));
            }
        } else {
            where = select.where();
        }
        if (rowRange.getCount() > 0) {
            // empty if block
        }
        return where;
    }

    private void bindWhereClauseForRowRange(List<Object> values, CqlRowSlice.RowRange<?> rowRange) {
        boolean keyIsPresent = false;
        boolean tokenIsPresent = false;
        if (rowRange.getStartKey() != null || rowRange.getEndKey() != null) {
            keyIsPresent = true;
        }
        if (rowRange.getStartToken() != null || rowRange.getEndToken() != null) {
            tokenIsPresent = true;
        }
        if (keyIsPresent && tokenIsPresent) {
            throw new RuntimeException("Cannot provide both token and keys for range query");
        }
        if (keyIsPresent) {
            if (rowRange.getStartKey() != null) {
                values.add(rowRange.getStartKey());
            }
            if (rowRange.getEndKey() != null) {
                values.add(rowRange.getEndKey());
            }
        } else if (tokenIsPresent) {
            BigInteger startTokenB = rowRange.getStartToken() != null ? new BigInteger(rowRange.getStartToken()) : null;
            BigInteger endTokenB = rowRange.getEndToken() != null ? new BigInteger(rowRange.getEndToken()) : null;
            Long startToken = startTokenB.longValue();
            Long endToken = endTokenB.longValue();
            if (startToken != null && endToken != null) {
                if (startToken != null) {
                    values.add(startToken);
                }
                if (endToken != null) {
                    values.add(endToken);
                }
            }
            if (rowRange.getCount() > 0) {
                // empty if block
            }
            return;
        }
    }

    public BoundStatement getQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        switch (rowSliceQuery.getRowQueryType()) {
            case RowKeys: {
                return this.getRowKeysQueryStatement(rowSliceQuery, useCaching);
            }
            case RowRange: {
                return this.getRowRangeQueryStatement(rowSliceQuery, useCaching);
            }
        }
        throw new RuntimeException("RowSliceQuery use case not supported.");
    }

    public BoundStatement getRowKeysQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        switch (rowSliceQuery.getColQueryType()) {
            case AllColumns: {
                return this.SelectAllColumnsForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnSet: {
                return this.SelectColumnSetForRowKeys.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnRange: {
                throw new RuntimeException("RowSliceQuery use case not supported.");
            }
        }
        throw new RuntimeException("RowSliceQuery use case not supported.");
    }

    public BoundStatement getRowRangeQueryStatement(CqlRowSliceQueryImpl<?, ?> rowSliceQuery, boolean useCaching) {
        switch (rowSliceQuery.getColQueryType()) {
            case AllColumns: {
                return this.SelectAllColumnsForRowRange.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnSet: {
                return this.SelectColumnSetForRowRange.getBoundStatement(rowSliceQuery, useCaching);
            }
            case ColumnRange: {
                throw new RuntimeException("RowSliceQuery use case not supported.");
            }
        }
        throw new RuntimeException("RowSliceQuery use case not supported.");
    }
}

