/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryGenCache<Q> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryGenCache.class);
    private AtomicReference<Session> sessionRef = new AtomicReference<Object>(null);
    private final AtomicReference<PreparedStatement> cachedStatement = new AtomicReference<Object>(null);

    public QueryGenCache(AtomicReference<Session> sessionR) {
        this.sessionRef = sessionR;
    }

    public BoundStatement getBoundStatement(Q query, boolean useCaching) {
        PreparedStatement pStatement = this.getPreparedStatement(query, useCaching);
        return this.bindValues(pStatement, query);
    }

    public PreparedStatement getPreparedStatement(Q query, boolean useCaching) {
        PreparedStatement pStatement = null;
        if (useCaching) {
            pStatement = this.cachedStatement.get();
        }
        if (pStatement == null) {
            try {
                RegularStatement stmt = this.getQueryGen(query).call();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Query: " + stmt.getQueryString());
                }
                pStatement = this.sessionRef.get().prepare(stmt.getQueryString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (useCaching && this.cachedStatement.get() == null) {
            this.cachedStatement.set(pStatement);
        }
        return pStatement;
    }

    public abstract Callable<RegularStatement> getQueryGen(Q var1);

    public abstract BoundStatement bindValues(PreparedStatement var1, Q var2);
}

