/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.netflix.astyanax.cql.reads.model.CqlRangeBuilder;
import com.netflix.astyanax.cql.reads.model.CqlRangeImpl;
import com.netflix.astyanax.model.ColumnSlice;
import java.util.Collection;

public class CqlColumnSlice<C>
extends ColumnSlice<C> {
    private CqlRangeImpl<C> cqlRange;
    private Collection<C> cqlColumns;

    public CqlColumnSlice() {
        super(null, null);
    }

    public CqlColumnSlice(C startColumn, C endColumn) {
        super(null, null);
    }

    public CqlColumnSlice(CqlRangeImpl<C> cqlRange) {
        super(null, null);
        this.cqlRange = cqlRange;
    }

    public CqlColumnSlice(Collection<C> columns) {
        super(null, null);
        this.cqlColumns = columns;
    }

    public void setColumns(Collection<C> columns) {
        this.cqlColumns = columns;
    }

    public void setCqlRange(CqlRangeImpl<C> cqlRange) {
        this.cqlRange = cqlRange;
    }

    public CqlColumnSlice(ColumnSlice<C> columnSlice) {
        super(null, null);
        if (columnSlice instanceof CqlColumnSlice) {
            this.initFrom((CqlColumnSlice)columnSlice);
        } else if (columnSlice.getColumns() != null) {
            this.cqlColumns = columnSlice.getColumns();
            this.cqlRange = null;
        } else {
            this.cqlColumns = null;
            this.cqlRange = new CqlRangeBuilder().setColumn("column1").setStart(columnSlice.getStartColumn()).setEnd(columnSlice.getEndColumn()).setReversed(columnSlice.getReversed()).setLimit(columnSlice.getLimit()).build();
        }
    }

    public CqlColumnSlice(CqlColumnSlice<C> cqlColumnSlice) {
        super(null, null);
        this.initFrom(cqlColumnSlice);
    }

    private void initFrom(CqlColumnSlice<C> cqlColumnSlice) {
        this.cqlColumns = cqlColumnSlice.cqlColumns;
        this.cqlRange = cqlColumnSlice.cqlRange;
    }

    public ColumnSlice<C> setLimit(int limit) {
        this.cqlRange = new CqlRangeBuilder<C>().withRange(this.cqlRange).setLimit(limit).build();
        return this;
    }

    public ColumnSlice<C> setReversed(boolean value) {
        this.cqlRange = new CqlRangeBuilder<C>().withRange(this.cqlRange).setReversed(value).build();
        return this;
    }

    public String getColumnName() {
        return this.cqlRange.getColumnName();
    }

    public Collection<C> getColumns() {
        return this.cqlColumns;
    }

    public C getStartColumn() {
        return this.cqlRange != null ? (C)this.cqlRange.getCqlStart() : null;
    }

    public C getEndColumn() {
        return this.cqlRange != null ? (C)this.cqlRange.getCqlEnd() : null;
    }

    public boolean getReversed() {
        return this.cqlRange != null ? this.cqlRange.isReversed() : false;
    }

    public int getLimit() {
        return this.cqlRange != null ? this.cqlRange.getLimit() : -1;
    }

    public int getFetchSize() {
        return this.cqlRange != null ? this.cqlRange.getFetchSize() : -1;
    }

    public boolean isColumnSelectQuery() {
        return this.cqlColumns != null;
    }

    public boolean isRangeQuery() {
        if (this.isColumnSelectQuery()) {
            return false;
        }
        return this.cqlRange != null;
    }

    public boolean isSelectAllQuery() {
        return !this.isColumnSelectQuery() && !this.isRangeQuery();
    }

    public QueryType getQueryType() {
        if (this.isSelectAllQuery()) {
            return QueryType.SELECT_ALL;
        }
        if (this.isRangeQuery()) {
            return QueryType.COLUMN_RANGE;
        }
        return QueryType.COLUMN_COLLECTION;
    }

    public static enum QueryType {
        SELECT_ALL,
        COLUMN_COLLECTION,
        COLUMN_RANGE;

    }
}

