/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.reads.model;

import com.netflix.astyanax.cql.reads.model.CqlColumnListImpl;
import com.netflix.astyanax.cql.util.CqlTypeMapping;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import java.nio.ByteBuffer;
import java.util.List;

public class CqlRowImpl<K, C>
implements Row<K, C> {
    private final K rowKey;
    private final CqlColumnListImpl<C> cqlColumnList;
    private final ColumnFamily<K, C> cf;

    public CqlRowImpl(com.datastax.driver.core.Row resultRow, ColumnFamily<K, C> cf) {
        this.rowKey = this.getRowKey(resultRow, cf);
        this.cqlColumnList = new CqlColumnListImpl(resultRow, cf);
        this.cf = cf;
    }

    public CqlRowImpl(List<com.datastax.driver.core.Row> rows, ColumnFamily<K, C> cf) {
        this.rowKey = this.getRowKey(rows.get(0), cf);
        this.cqlColumnList = new CqlColumnListImpl(rows, cf);
        this.cf = cf;
    }

    public CqlRowImpl(K rKey, CqlColumnListImpl<C> colList, ColumnFamily<K, C> columnFamily) {
        this.rowKey = rKey;
        this.cqlColumnList = colList;
        this.cf = columnFamily;
    }

    public K getKey() {
        return this.rowKey;
    }

    public ByteBuffer getRawKey() {
        return this.cf.getKeySerializer().toByteBuffer(this.rowKey);
    }

    public ColumnList<C> getColumns() {
        return this.cqlColumnList;
    }

    private Object getRowKey(com.datastax.driver.core.Row row, ColumnFamily<K, C> cf) {
        return CqlTypeMapping.getDynamicColumn(row, cf.getKeySerializer(), 0, cf);
    }
}

