/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.NettyTransportCodec;
import org.apache.avro.ipc.Transceiver;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTransceiver
extends Transceiver {
    private static final Logger LOG = LoggerFactory.getLogger((String)NettyTransceiver.class.getName());
    private ChannelFactory channelFactory;
    private Channel channel;
    private AtomicInteger serialGenerator = new AtomicInteger(0);
    private Map<Integer, CallFuture> requests = new ConcurrentHashMap<Integer, CallFuture>();
    private Protocol remote;

    public NettyTransceiver(InetSocketAddress addr) {
        this.channelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        ClientBootstrap bootstrap = new ClientBootstrap(this.channelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("frameDecoder", (ChannelHandler)new NettyTransportCodec.NettyFrameDecoder());
                p.addLast("frameEncoder", (ChannelHandler)new NettyTransportCodec.NettyFrameEncoder());
                p.addLast("handler", (ChannelHandler)new NettyClientAvroHandler());
                return p;
            }
        });
        bootstrap.setOption("tcpNoDelay", (Object)true);
        ChannelFuture channelFuture = bootstrap.connect((SocketAddress)addr);
        channelFuture.awaitUninterruptibly();
        if (!channelFuture.isSuccess()) {
            channelFuture.getCause().printStackTrace();
            throw new RuntimeException(channelFuture.getCause());
        }
        this.channel = channelFuture.getChannel();
    }

    @Override
    public void close() {
        this.channel.close().awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
    }

    @Override
    public String getRemoteName() {
        return this.channel.getRemoteAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ByteBuffer> transceive(List<ByteBuffer> request) throws IOException {
        int serial = this.serialGenerator.incrementAndGet();
        NettyTransportCodec.NettyDataPack dataPack = new NettyTransportCodec.NettyDataPack(serial, request);
        CallFuture callFuture = new CallFuture();
        this.requests.put(serial, callFuture);
        this.channel.write((Object)dataPack);
        try {
            Object object = callFuture.get();
            return object;
        }
        catch (InterruptedException e) {
            LOG.warn("failed to get the response", (Throwable)e);
            List<ByteBuffer> list = null;
            return list;
        }
        catch (ExecutionException e) {
            LOG.warn("failed to get the response", (Throwable)e);
            List<ByteBuffer> list = null;
            return list;
        }
        finally {
            this.requests.remove(serial);
        }
    }

    @Override
    public void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ByteBuffer> readBuffers() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Protocol getRemote() {
        return this.remote;
    }

    @Override
    public boolean isConnected() {
        return this.remote != null;
    }

    @Override
    public void setRemote(Protocol protocol) {
        this.remote = protocol;
    }

    class NettyClientAvroHandler
    extends SimpleChannelUpstreamHandler {
        NettyClientAvroHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof ChannelStateEvent) {
                LOG.info(e.toString());
            }
            super.handleUpstream(ctx, e);
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelOpen(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
            NettyTransportCodec.NettyDataPack dataPack = (NettyTransportCodec.NettyDataPack)e.getMessage();
            CallFuture callFuture = (CallFuture)NettyTransceiver.this.requests.get(dataPack.getSerial());
            if (callFuture == null) {
                throw new RuntimeException("Missing previous call info");
            }
            callFuture.setResponse(dataPack.getDatas());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            LOG.warn("Unexpected exception from downstream.", e.getCause());
            e.getChannel().close();
            Iterator it = NettyTransceiver.this.requests.values().iterator();
            while (it.hasNext()) {
                ((CallFuture)it.next()).releaseSemphore();
                it.remove();
            }
        }
    }

    class CallFuture
    implements Future<List<ByteBuffer>> {
        private Semaphore sem = new Semaphore(0);
        private List<ByteBuffer> response = null;

        CallFuture() {
        }

        public void setResponse(List<ByteBuffer> response) {
            this.response = response;
            this.sem.release();
        }

        public void releaseSemphore() {
            this.sem.release();
        }

        public List<ByteBuffer> getResponse() {
            return this.response;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public List<ByteBuffer> get() throws InterruptedException, ExecutionException {
            this.sem.acquire();
            return this.response;
        }

        @Override
        public List<ByteBuffer> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.sem.tryAcquire(timeout, unit)) {
                return this.response;
            }
            throw new TimeoutException();
        }

        @Override
        public boolean isDone() {
            return this.sem.availablePermits() > 0;
        }
    }
}

