/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.completion;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.search.suggest.completion.AnalyzingCompletionLookupProvider;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionContext;
import org.elasticsearch.search.suggest.completion.CompletionTokenStream;
import org.elasticsearch.search.suggest.completion.PayloadProcessor;

public class Completion090PostingsFormat
extends PostingsFormat {
    public static final String CODEC_NAME = "completion090";
    public static final int SUGGEST_CODEC_VERSION = 1;
    public static final int SUGGEST_VERSION_CURRENT = 1;
    public static final String EXTENSION = "cmp";
    private static final ESLogger logger = Loggers.getLogger(Completion090PostingsFormat.class);
    private PostingsFormat delegatePostingsFormat;
    private static final Map<String, CompletionLookupProvider> providers;
    private CompletionLookupProvider writeProvider;

    public Completion090PostingsFormat(PostingsFormat delegatePostingsFormat, CompletionLookupProvider provider) {
        super(CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.writeProvider = provider;
        assert (delegatePostingsFormat != null && this.writeProvider != null);
    }

    public Completion090PostingsFormat() {
        super(CODEC_NAME);
    }

    public CompletionFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        assert (this.writeProvider != null);
        return new CompletionFieldsConsumer(state);
    }

    public CompletionFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new CompletionFieldsProducer(state);
    }

    public CompletionStats completionStats(IndexReader indexReader, String ... fieldNamePatterns) {
        CompletionStats completionStats = new CompletionStats();
        for (LeafReaderContext atomicReaderContext : indexReader.leaves()) {
            LeafReader atomicReader = atomicReaderContext.reader();
            try {
                Fields fields = atomicReader.fields();
                for (String fieldName : fields) {
                    Terms terms = fields.terms(fieldName);
                    if (!(terms instanceof CompletionTerms)) continue;
                    CompletionTerms completionTerms = (CompletionTerms)terms;
                    completionStats.add(completionTerms.stats(fieldNamePatterns));
                }
            }
            catch (IOException ioe) {
                logger.error("Could not get completion stats", ioe, new Object[0]);
            }
        }
        return completionStats;
    }

    static {
        AnalyzingCompletionLookupProvider provider = new AnalyzingCompletionLookupProvider(true, false, true, false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        providers = builder.put((Object)((CompletionLookupProvider)provider).getName(), (Object)provider).build();
    }

    public static abstract class LookupFactory
    implements Accountable {
        public abstract Lookup getLookup(CompletionFieldMapper.CompletionFieldType var1, CompletionSuggestionContext var2);

        public abstract CompletionStats stats(String ... var1);

        abstract AnalyzingCompletionLookupProvider.AnalyzingSuggestHolder getAnalyzingSuggestHolder(MappedFieldType var1);
    }

    public static abstract class CompletionLookupProvider
    implements PayloadProcessor,
    CompletionTokenStream.ToFiniteStrings {
        public static final char UNIT_SEPARATOR = '\u001f';

        public abstract FieldsConsumer consumer(IndexOutput var1) throws IOException;

        public abstract String getName();

        public abstract LookupFactory load(IndexInput var1) throws IOException;

        @Override
        public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
            if (weight < -1L || weight > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("weight must be >= -1 && <= Integer.MAX_VALUE");
            }
            for (int i = 0; i < surfaceForm.length; ++i) {
                if (surfaceForm.bytes[i] != 31) continue;
                throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamDataOutput output = new OutputStreamDataOutput((OutputStream)byteArrayOutputStream);
            output.writeVLong(weight + 1L);
            output.writeVInt(surfaceForm.length);
            output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
            output.writeVInt(payload.length);
            output.writeBytes(payload.bytes, 0, payload.length);
            output.close();
            return new BytesRef(byteArrayOutputStream.toByteArray());
        }

        @Override
        public void parsePayload(BytesRef payload, PayloadProcessor.SuggestPayload ref) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payload.bytes, payload.offset, payload.length);
            InputStreamDataInput input = new InputStreamDataInput((InputStream)byteArrayInputStream);
            ref.weight = input.readVLong() - 1L;
            int len = input.readVInt();
            ref.surfaceForm.grow(len);
            ref.surfaceForm.setLength(len);
            input.readBytes(ref.surfaceForm.bytes(), 0, ref.surfaceForm.length());
            len = input.readVInt();
            ref.payload.grow(len);
            ref.payload.setLength(len);
            input.readBytes(ref.payload.bytes(), 0, ref.payload.length());
            input.close();
        }
    }

    public static final class CompletionTerms
    extends FilterLeafReader.FilterTerms {
        private final LookupFactory lookup;

        public CompletionTerms(Terms delegate, LookupFactory lookup) {
            super(delegate);
            this.lookup = lookup;
        }

        public Lookup getLookup(CompletionFieldMapper.CompletionFieldType mapper, CompletionSuggestionContext suggestionContext) {
            return this.lookup.getLookup(mapper, suggestionContext);
        }

        public CompletionStats stats(String ... fields) {
            return this.lookup.stats(fields);
        }
    }

    private static class CompletionFieldsProducer
    extends FieldsProducer {
        private final FieldsProducer delegateProducer;
        private final LookupFactory lookupFactory;
        private final int version;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletionFieldsProducer(SegmentReadState state) throws IOException {
            block6: {
                IndexInput input;
                block5: {
                    String suggestFSTFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)Completion090PostingsFormat.EXTENSION);
                    input = state.directory.openInput(suggestFSTFile, state.context);
                    this.version = CodecUtil.checkHeader((DataInput)input, (String)Completion090PostingsFormat.CODEC_NAME, (int)1, (int)1);
                    FieldsProducer delegateProducer = null;
                    boolean success = false;
                    try {
                        PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)input.readString());
                        String providerName = input.readString();
                        CompletionLookupProvider completionLookupProvider = (CompletionLookupProvider)providers.get(providerName);
                        if (completionLookupProvider == null) {
                            throw new IllegalStateException("no provider with name [" + providerName + "] registered");
                        }
                        delegateProducer = delegatePostingsFormat.fieldsProducer(state);
                        this.lookupFactory = state.context.context != IOContext.Context.MERGE ? completionLookupProvider.load(input) : null;
                        this.delegateProducer = delegateProducer;
                        success = true;
                        if (success) break block5;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{delegateProducer, input});
                        } else {
                            IOUtils.close((Closeable[])new Closeable[]{input});
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{delegateProducer, input});
                    break block6;
                }
                IOUtils.close((Closeable[])new Closeable[]{input});
            }
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.delegateProducer});
        }

        public Iterator<String> iterator() {
            return this.delegateProducer.iterator();
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.delegateProducer.terms(field);
            if (terms == null || this.lookupFactory == null) {
                return terms;
            }
            return new CompletionTerms(terms, this.lookupFactory);
        }

        public int size() {
            return this.delegateProducer.size();
        }

        public long ramBytesUsed() {
            return (this.lookupFactory == null ? 0L : this.lookupFactory.ramBytesUsed()) + this.delegateProducer.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.lookupFactory != null) {
                resources.add(Accountables.namedAccountable((String)"lookup", (Accountable)this.lookupFactory));
            }
            resources.add(Accountables.namedAccountable((String)"delegate", (Accountable)this.delegateProducer));
            return Collections.unmodifiableList(resources);
        }

        public void checkIntegrity() throws IOException {
            this.delegateProducer.checkIntegrity();
        }

        public FieldsProducer getMergeInstance() throws IOException {
            return this.delegateProducer.getMergeInstance();
        }
    }

    private class CompletionFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegatesFieldsConsumer;
        private FieldsConsumer suggestFieldsConsumer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CompletionFieldsConsumer(SegmentWriteState state) throws IOException {
            this.delegatesFieldsConsumer = Completion090PostingsFormat.this.delegatePostingsFormat.fieldsConsumer(state);
            String suggestFSTFile = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)Completion090PostingsFormat.EXTENSION);
            IndexOutput output = null;
            boolean success = false;
            try {
                output = state.directory.createOutput(suggestFSTFile, state.context);
                CodecUtil.writeHeader((DataOutput)output, (String)Completion090PostingsFormat.CODEC_NAME, (int)1);
                output.writeString(Completion090PostingsFormat.this.delegatePostingsFormat.getName());
                output.writeString(Completion090PostingsFormat.this.writeProvider.getName());
                this.suggestFieldsConsumer = Completion090PostingsFormat.this.writeProvider.consumer(output);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                throw throwable;
            }
        }

        public void write(Fields fields) throws IOException {
            this.delegatesFieldsConsumer.write(fields);
            this.suggestFieldsConsumer.write(fields);
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.delegatesFieldsConsumer, this.suggestFieldsConsumer});
        }
    }
}

