/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import java.net.InetSocketAddress;

class PooledConnection
extends Connection {
    private final HostConnectionPool pool;

    PooledConnection(String name, InetSocketAddress address, Connection.Factory factory, HostConnectionPool pool) throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException {
        super(name, address, factory);
        this.pool = pool;
    }

    public void release() {
        this.pool.returnConnection(this);
    }

    @Override
    protected void notifyOwnerWhenDefunct(boolean hostIsDown) {
        if (this.pool == null) {
            return;
        }
        if (hostIsDown) {
            this.pool.closeAsync();
        } else {
            this.pool.replace(this);
        }
    }
}

