/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeDecompressor
extends LZ4Decompressor {
    public static final LZ4Decompressor INSTANCE = new LZ4JavaSafeDecompressor();

    LZ4JavaSafeDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        int literalLen;
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (src[srcOff] != 0) {
                throw new LZ4Exception("Malformed input at " + srcOff);
            }
            return 1;
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int literalCopyEnd;
            int token;
            if ((literalLen = (token = src[sOff++] & 0xFF) >>> 4) == 15) {
                byte len;
                while ((len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                if (literalCopyEnd != destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                break;
            }
            LZ4Utils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            sOff += literalLen;
            dOff = literalCopyEnd;
            int matchDec = src[sOff++] & 0xFF | (src[sOff++] & 0xFF) << 8;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4Utils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        LZ4Utils.safeArraycopy(src, sOff, dest, dOff, literalLen);
        return (sOff += literalLen) - srcOff;
    }
}

