/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ColumnTimestampAndTTLTests
extends KeyspaceTests {
    private static ColumnFamily<Long, Long> CF_COL_TIMESTAMP = ColumnFamily.newColumnFamily((String)"columntimestamps", (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get(), (Serializer)LongSerializer.get());
    private static ColumnFamily<String, String> CF_TTL = ColumnFamily.newColumnFamily((String)"columnttls", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        ColumnTimestampAndTTLTests.initContext();
        keyspace.createColumnFamily(CF_COL_TIMESTAMP, null);
        keyspace.createColumnFamily(CF_TTL, null);
        CF_COL_TIMESTAMP.describe(keyspace);
        CF_TTL.describe(keyspace);
    }

    @AfterClass
    public static void teardown() throws Exception {
        keyspace.dropColumnFamily(CF_COL_TIMESTAMP);
        keyspace.dropColumnFamily(CF_TTL);
    }

    @Test
    public void testColumnTimestamps() throws Exception {
        CF_COL_TIMESTAMP.describe(keyspace);
        MutationBatch mb = keyspace.prepareMutationBatch();
        mb.withRow(CF_COL_TIMESTAMP, (Object)1L).setTimestamp(1L).putColumn((Object)1L, 1L).setTimestamp(10L).putColumn((Object)2L, 2L);
        mb.execute();
        ColumnList result1 = (ColumnList)keyspace.prepareQuery(CF_COL_TIMESTAMP).getRow((Object)1L).execute().getResult();
        Assert.assertEquals((long)2L, (long)result1.size());
        Assert.assertNotNull((Object)result1.getColumnByName((Object)1L));
        Assert.assertNotNull((Object)result1.getColumnByName((Object)2L));
        mb = keyspace.prepareMutationBatch();
        mb.withRow(CF_COL_TIMESTAMP, (Object)1L).setTimestamp(result1.getColumnByName((Object)1L).getTimestamp() - 1L).deleteColumn((Object)1L).setTimestamp(result1.getColumnByName((Object)2L).getTimestamp() - 1L).deleteColumn((Object)2L).putEmptyColumn((Object)3L, null);
        mb.execute();
        result1 = (ColumnList)keyspace.prepareQuery(CF_COL_TIMESTAMP).getRow((Object)1L).execute().getResult();
        Assert.assertEquals((long)3L, (long)result1.size());
        mb = keyspace.prepareMutationBatch();
        mb.withRow(CF_COL_TIMESTAMP, (Object)1L).setTimestamp(result1.getColumnByName((Object)1L).getTimestamp() + 1L).deleteColumn((Object)1L).setTimestamp(result1.getColumnByName((Object)2L).getTimestamp() + 1L).deleteColumn((Object)2L);
        mb.execute();
        result1 = (ColumnList)keyspace.prepareQuery(CF_COL_TIMESTAMP).getRow((Object)1L).execute().getResult();
        Assert.assertEquals((long)1L, (long)result1.size());
    }

    @Test
    public void testTtlValues() throws Exception {
        MutationBatch mb = keyspace.prepareMutationBatch();
        mb.withRow(CF_TTL, (Object)"row").putColumn((Object)"TTL0", "TTL0", Integer.valueOf(0)).putColumn((Object)"TTLNULL", "TTLNULL", null).putColumn((Object)"TTL1", "TTL1", Integer.valueOf(1));
        mb.execute();
        Thread.sleep(2000L);
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_TTL).getRow((Object)"row").execute().getResult();
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull((Object)result.getColumnByName((Object)"TTL0"));
        Assert.assertNotNull((Object)result.getColumnByName((Object)"TTLNULL"));
    }
}

