/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.CqlResult;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.query.CqlQuery;
import com.netflix.astyanax.query.PreparedCqlQuery;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectCqlTests
extends KeyspaceTests {
    public static ColumnFamily<Integer, String> CF_DIRECT = ColumnFamily.newColumnFamily((String)"cfdirect", (Serializer)IntegerSerializer.get(), (Serializer)StringSerializer.get());
    public static ColumnFamily<String, String> CF_EMPTY_TABLE = ColumnFamily.newColumnFamily((String)"empty_table", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        DirectCqlTests.initContext();
        keyspace.prepareQuery(CF_DIRECT).withCql("CREATE TABLE astyanaxunittests.cfdirect ( key int, column1 text, value bigint, PRIMARY KEY (key) )").execute();
        keyspace.prepareQuery(CF_EMPTY_TABLE).withCql("CREATE TABLE astyanaxunittests.empty_table ( key text, column1 text, value text, PRIMARY KEY (key) )").execute();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.prepareQuery(CF_DIRECT).withCql("DROP TABLE astyanaxunittests.cfdirect").execute();
        keyspace.prepareQuery(CF_EMPTY_TABLE).withCql("DROP TABLE astyanaxunittests.empty_table").execute();
    }

    @Test
    public void testCql() throws Exception {
        CqlQuery cqlQuery = keyspace.prepareQuery(CF_DIRECT).withCql("INSERT INTO astyanaxunittests.cfdirect (key, column1, value) VALUES (?,?,?)");
        for (int i = 0; i < 10; ++i) {
            PreparedCqlQuery pStatement = cqlQuery.asPreparedStatement();
            pStatement.withIntegerValue(Integer.valueOf(i)).withStringValue("" + i).withLongValue(Long.valueOf("" + i)).execute();
        }
        OperationResult result = keyspace.prepareQuery(CF_DIRECT).withCql("SELECT * FROM astyanaxunittests.cfdirect;").execute();
        Assert.assertTrue((boolean)((CqlResult)result.getResult()).hasRows());
        Assert.assertEquals((int)10, (int)((CqlResult)result.getResult()).getRows().size());
        Assert.assertFalse((boolean)((CqlResult)result.getResult()).hasNumber());
        for (int i = 0; i < 10; ++i) {
            Row row = ((CqlResult)result.getResult()).getRows().getRow((Object)i);
            Assert.assertTrue((i == (Integer)row.getKey() ? 1 : 0) != 0);
            Assert.assertEquals((int)3, (int)row.getColumns().size());
            Integer key = row.getColumns().getIntegerValue((Object)"key", null);
            Assert.assertTrue((Integer.valueOf("" + i) == key ? 1 : 0) != 0);
            String column1 = row.getColumns().getStringValue((Object)"column1", null);
            Assert.assertEquals((String)("" + i), (String)column1);
            Long value = row.getColumns().getLongValue((Object)"value", null);
            Assert.assertTrue((Long.valueOf("" + i) == value ? 1 : 0) != 0);
        }
        result = keyspace.prepareQuery(CF_DIRECT).withCql("SELECT count(*) FROM astyanaxunittests.cfdirect;").execute();
        Assert.assertFalse((boolean)((CqlResult)result.getResult()).hasRows());
        Assert.assertTrue((boolean)((CqlResult)result.getResult()).hasNumber());
        Assert.assertTrue((10 == ((CqlResult)result.getResult()).getNumber() ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyTable() throws Exception {
        CqlResult result = (CqlResult)keyspace.prepareQuery(CF_EMPTY_TABLE).withCql("select * from astyanaxunittests.empty_table where  key = 'blah'").execute().getResult();
        Assert.assertFalse((boolean)result.hasRows());
        Assert.assertFalse((boolean)result.hasNumber());
        Assert.assertTrue((0 == result.getRows().size() ? 1 : 0) != 0);
    }
}

