package org.gcube.social_networking.socialutillibrary;

import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.gcube.socialnetworking.token.ReplaceableToken;
import org.gcube.socialnetworking.token.TagToken;
import org.gcube.socialnetworking.token.Token;
import org.gcube.socialnetworking.token.URLToken;

public class MessageParser {

	private final String originalMessage;
	
	private StringWriter stringWriter;
	private List<ReplaceableToken> tokens;
	
	public MessageParser(String message) {
		this.originalMessage = message;
	}
	
	public List<ReplaceableToken> getTokens() {
		if(tokens==null){
			tokens = new ArrayList<>();
			SocialStringTokenizer socialStringTokenizer = new SocialStringTokenizer(originalMessage);
			for(Token token : socialStringTokenizer.getTokens()) {
				String tokenString = token.getToken();
				if(tokenString.startsWith("#")) {
					TagToken tagToken = new TagToken(token);
					tokens.add(tagToken);
					continue;
				}
				
				URL url = URLToken.isURL(tokenString);
				if(url!=null) {
					URLToken urlToken = new URLToken(token, url);
					tokens.add(urlToken);
					continue;
				}
				
				ReplaceableToken replaceableToken = new ReplaceableToken(token);
				tokens.add(replaceableToken);
			}
		}
		return tokens;
	}
	
	public String getParsedMessage() {
		if(stringWriter==null) {
			stringWriter = new StringWriter();
			for(ReplaceableToken token : getTokens()) {
				stringWriter.append(token.getTokenReplacement());
				stringWriter.append(token.getDelimiter());
			}
		}
		return stringWriter.toString();
	}
	
}
