package org.gcube.socialnetworking.token;

import org.gcube.portal.databook.client.GCubeSocialNetworking;

public class TagToken extends ReplaceableToken {

	private boolean replaced;
	
	public TagToken(Token token) {
		super(token);
		replaced = false;
	}
	
	public String getTokenReplacement() {
		if(!replaced) {
			String linkTarget = createHref("", GCubeSocialNetworking.HASHTAG_OID, token);
			tokenReplacement = createLink(linkTarget, token, null);
			replaced = true;
		}
		return super.getTokenReplacement();
	}
	
}
