/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis;

import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.gis.ResearchMethod;
import org.gcube.spatial.data.gis.model.GeoServerDescriptor;
import org.gcube.spatial.data.gis.model.InfrastructureCrawler;
import org.opengis.metadata.Metadata;

public class GISInterface {
    private static final long MAX_GEOSERVER_CACHE_TIME = 120000L;
    private GeoNetworkPublisher geoNetwork = null;
    private ConcurrentSkipListSet<GeoServerDescriptor> geoservers = new ConcurrentSkipListSet();
    private long lastAccessedTime = 0L;

    public static GISInterface get() throws Exception {
        return new GISInterface();
    }

    private GISInterface() throws Exception {
    }

    public GeoNetworkReader getGeoNetworkReader() throws Exception {
        return this.getGN();
    }

    public GeoNetworkPublisher getGeoNewtorkPublisher() throws Exception {
        return this.getGN();
    }

    public GeoServerRESTReader getGeoServerReader(ResearchMethod method, boolean forceRefresh) throws Exception {
        GeoServerDescriptor desc = this.getGeoServerSet(forceRefresh).last();
        return this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getReader();
    }

    public GeoServerRESTReader getGeoServerReader(String url, String user, String password) throws IllegalArgumentException, MalformedURLException {
        return this.getGeoServerManager(url, user, password).getReader();
    }

    public GeoServerRESTReader getGeoServerReader(String url) throws MalformedURLException {
        return new GeoServerRESTReader(url);
    }

    public void addGeoTIFF(String workspace, String storeName, String coverageName, File geotiff, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox, Metadata geoNetworkMeta) throws FileNotFoundException, IllegalArgumentException, MalformedURLException, Exception {
        GeoServerDescriptor desc = this.getGeoServerSet(false).last();
        GeoServerRESTPublisher publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
        boolean publishResult = publisher.publishGeoTIFF(workspace, storeName, coverageName, geotiff, srs, policy, defaultStyle, bbox);
    }

    private synchronized SortedSet<GeoServerDescriptor> getGeoServerSet(boolean forceRefresh) throws Exception {
        if (forceRefresh || this.geoservers.size() == 0 || System.currentTimeMillis() - this.lastAccessedTime > 120000L) {
            this.geoservers.clear();
            this.geoservers.addAll(InfrastructureCrawler.queryforGeoServer());
            this.lastAccessedTime = System.currentTimeMillis();
        }
        return this.geoservers;
    }

    private synchronized GeoNetworkPublisher getGN() throws Exception {
        if (this.geoNetwork == null) {
            this.geoNetwork = GeoNetwork.get();
        }
        return this.geoNetwork;
    }

    private GeoServerRESTManager getGeoServerManager(String url, String user, String password) throws IllegalArgumentException, MalformedURLException {
        return new GeoServerRESTManager(new URL(url), user, password);
    }
}

