package org.gcube.spatial.data.gis.model;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;

public class InfrastructureCrawler {

	
	public static List<GeoServerDescriptor> queryforGeoServer() throws Exception{
		List<GeoServerDescriptor> toReturn=new ArrayList<GeoServerDescriptor>();
		SimpleQuery query = queryFor(ServiceEndpoint.class);
		 
		query.addCondition("$resource/Profile/Category/text() eq 'Gis'")
				.addCondition("$resource/Profile/Platform/Name/text() eq 'geonetwork'")
		         .setResult("$resource/Profile/AccessPoint");
		 
		DiscoveryClient<AccessPoint> client = clientFor(AccessPoint.class);
		 
		List<AccessPoint> accesspoints = client.submit(query);
//		if(accesspoints.size()==0) throw new Exception("No Resource found under current scope "+ScopeProvider.instance.get()); 
		for (AccessPoint point : accesspoints) {
			toReturn.add(new GeoServerDescriptor(point.address(),point.username(),point.password(),0l));
//			url=point.address();
//			user=point.username();
//			pwd=point.password();
		}
		return toReturn; 
	}
	
}
