/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.symbology;

import java.awt.Color;
import java.awt.RenderingHints;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.measure.unit.NonSI;
import javax.xml.bind.JAXBException;
import org.gcube.spatial.data.gis.symbology.Range;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.sld.DefaultSLDFactory;
import org.geotoolkit.sld.MutableSLDFactory;
import org.geotoolkit.sld.xml.Specification;
import org.geotoolkit.sld.xml.XMLUtilities;
import org.geotoolkit.style.MutableFeatureTypeStyle;
import org.geotoolkit.style.MutableRule;
import org.geotoolkit.style.MutableStyle;
import org.geotoolkit.style.MutableStyleFactory;
import org.geotoolkit.style.StyleConstants;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Style;

public class StyleUtils {
    protected static final FilterFactory FF = FactoryFinder.getFilterFactory(null);
    protected static final MutableSLDFactory SLDF = new DefaultSLDFactory();
    protected static final MutableStyleFactory SF = (MutableStyleFactory)FactoryFinder.getStyleFactory((Hints)new Hints((RenderingHints.Key)Hints.STYLE_FACTORY, MutableStyleFactory.class));
    protected static XMLUtilities utils = new XMLUtilities();

    public static String createStyle(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, true);
    }

    public static String createStyleLog(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyle(nameStyle, attributeName, maxClasses, c1, c2, typeValue, maxValue, minValue, false);
    }

    public static String createStyleScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, true);
    }

    public static String createStyleLogScatterColors(String nameStyle, String attributeName, int nClasses, Class typeValue, Object maxValue, Object minValue) throws Exception {
        return StyleUtils.createStyleScatterColors(nameStyle, attributeName, nClasses, typeValue, maxValue, minValue, false);
    }

    public static String createStyle(String nameStyle, String attributeName, ArrayList<ClassStyleDef> classes, Color c1, Color c2) throws Exception {
        if (classes.size() <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Color> colors = StyleUtils.scatterColor(classes.size());
        for (int i = 0; i < classes.size(); ++i) {
            ClassStyleDef classStyle = classes.get(i);
            fts.rules().add(StyleUtils.makeRule(new Range(attributeName, colors.get(i), classStyle.getFrom(), classStyle.getTo(), Range.Condition.BETWEEN)));
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String createStyle(String nameStyle, String attributeName, int maxClasses, Color c1, Color c2, Class typeValue, Object maxValue, Object minValue, boolean linear) throws Exception {
        if (maxClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Range> ranges = StyleUtils.getRanges(typeValue, maxClasses, maxValue, minValue, attributeName, linear);
        ArrayList<Color> colors = StyleUtils.gradientColors(ranges.size(), c1, c2);
        for (int i = 0; i < ranges.size(); ++i) {
            ranges.get(i).setToAssignColor(colors.get(i));
        }
        for (Range r : ranges) {
            fts.rules().add(StyleUtils.makeRule(r));
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String createStyleScatterColors(String nameStyle, String attributeName, int maxClasses, Class typeValue, Object maxValue, Object minValue, boolean linear) throws Exception {
        if (maxClasses <= 0) {
            throw new Exception("Invalid number of classes!!");
        }
        MutableStyle style = SF.style();
        MutableFeatureTypeStyle fts = SF.featureTypeStyle();
        ArrayList<Range> ranges = StyleUtils.getRanges(typeValue, maxClasses, maxValue, minValue, attributeName, linear);
        ArrayList<Color> colors = StyleUtils.scatterColor(ranges.size());
        for (int i = 0; i < ranges.size(); ++i) {
            ranges.get(i).setToAssignColor(colors.get(i));
        }
        for (Range r : ranges) {
            fts.rules().add(StyleUtils.makeRule(r));
        }
        style.featureTypeStyles().add(fts);
        style.setName(nameStyle);
        return StyleUtils.marshall((Style)style);
    }

    private static String marshall(Style toMarshal) throws JAXBException {
        StringWriter writer = new StringWriter();
        utils.writeStyle((Object)writer, toMarshal, Specification.StyledLayerDescriptor.V_1_0_0);
        return writer.toString().replaceAll("<([a-zA-Z][a-zA-Z0-9:]*)[^>]*>\\s*</\\1>", "");
    }

    private static MutableRule makeRule(Range r) {
        MutableRule toReturn = SF.rule();
        toReturn.setName(r.getToFilterProperty() + " in [" + r.getMin() + " , " + r.getMax() + ")");
        switch (r.getCondition()) {
            case BETWEEN: {
                toReturn.setFilter((Filter)FF.and((Filter)FF.greaterOrEqual((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMin())), (Filter)FF.less((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMax()))));
                break;
            }
            case GREATER_THEN_MIN: {
                toReturn.setFilter((Filter)FF.greaterOrEqual((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMin())));
                break;
            }
            case UP_TO_MAX: {
                toReturn.setFilter((Filter)FF.less((Expression)FF.property(r.getToFilterProperty()), (Expression)FF.literal(r.getMax())));
            }
        }
        toReturn.symbolizers().add(SF.polygonSymbolizer(toReturn.getName(), "the_geom", StyleConstants.DEFAULT_DESCRIPTION, NonSI.PIXEL, null, SF.fill(r.getToAssignColor()), StyleConstants.DEFAULT_DISPLACEMENT, (Expression)StyleConstants.LITERAL_ZERO_FLOAT));
        return toReturn;
    }

    private static ArrayList<Range> getRanges(Class typeValue, int maxClasses, Object maxValue, Object minValue, String attributeName, boolean linear) throws Exception {
        Double dMin;
        Double dMax;
        if (maxValue.getClass() != minValue.getClass()) {
            throw new Exception("Min (" + minValue.getClass() + ")and Max (" + maxValue.getClass() + ") value must be of same class");
        }
        boolean integerRanges = typeValue.isAssignableFrom(Integer.class);
        if (maxValue instanceof Double) {
            dMax = (Double)maxValue;
            dMin = (Double)minValue;
        } else if (maxValue instanceof Float) {
            dMax = new Double(((Float)maxValue).floatValue());
            dMin = new Double(((Float)minValue).floatValue());
        } else if (maxValue instanceof Integer) {
            dMax = (double)((Integer)maxValue).intValue() * 1.0;
            dMin = (double)((Integer)minValue).intValue() * 1.0;
        } else if (maxValue instanceof String) {
            dMax = Double.parseDouble((String)maxValue);
            dMin = Double.parseDouble((String)minValue);
        } else {
            throw new Exception("Unable to handle range values class " + maxValue.getClass());
        }
        if (dMax.compareTo(dMin) < 0) {
            throw new Exception("Specified Range [" + dMin + " , " + dMax + ") is invalid");
        }
        ArrayList<Range> toReturn = new ArrayList<Range>();
        if (linear) {
            double distance = Math.abs(dMin - dMax);
            double step = distance / (double)maxClasses;
            if (integerRanges && step < 1.0) {
                step = 1.0;
            }
            Double toInsertMin = StyleUtils.roundDecimal(dMin, integerRanges ? 0 : 2);
            Double toInsertMax = StyleUtils.roundDecimal(toInsertMin + step, integerRanges ? 0 : 2);
            while (dMax.compareTo(toInsertMax) >= 0) {
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin.intValue(), toInsertMax.intValue(), Range.Condition.BETWEEN));
                } else {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin, toInsertMax, Range.Condition.BETWEEN));
                }
                toInsertMin = toInsertMax;
                toInsertMax = StyleUtils.roundDecimal(toInsertMin + step, integerRanges ? 0 : 2);
            }
            if (!dMax.equals(toInsertMin)) {
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin.intValue(), dMax.intValue(), Range.Condition.BETWEEN));
                } else {
                    toReturn.add(new Range(attributeName, Color.RED, toInsertMin, dMax, Range.Condition.BETWEEN));
                }
            }
        } else {
            Double[] logSub = StyleUtils.logSubdivision(dMin, dMax, maxClasses);
            for (int i = 0; i < logSub.length; ++i) {
                Double upperBound;
                Double d = upperBound = i == logSub.length - 1 ? dMax : logSub[i + 1];
                upperBound = dMax.compareTo(upperBound) <= 0 ? Double.valueOf(StyleUtils.roundDecimal(dMax, integerRanges ? 0 : 2)) : Double.valueOf(StyleUtils.roundDecimal(upperBound, integerRanges ? 0 : 2));
                Double lowerBound = StyleUtils.roundDecimal(logSub[i], integerRanges ? 0 : 2);
                if (integerRanges) {
                    toReturn.add(new Range(attributeName, Color.RED, lowerBound.intValue(), upperBound.intValue(), Range.Condition.BETWEEN));
                    continue;
                }
                toReturn.add(new Range(attributeName, Color.RED, lowerBound, upperBound, Range.Condition.BETWEEN));
            }
        }
        return toReturn;
    }

    private static ArrayList<Color> gradientColors(int nColors, Color c1, Color c2) {
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < nColors; ++i) {
            float ratio = (float)i / (float)nColors;
            int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
            int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
            int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
            colors.add(new Color(red, green, blue));
        }
        return colors;
    }

    private static double roundDecimal(double number, int decimalposition) {
        double n = (double)Math.round(number * Math.pow(10.0, decimalposition)) / Math.pow(10.0, decimalposition);
        return n;
    }

    private static Double[] logSubdivision(double start, double end, int numberOfParts) {
        if (end <= start) {
            return null;
        }
        double logStart = Math.log(start);
        double logEnd = Math.log(end);
        double difference = logEnd - logStart;
        double step = 0.0;
        if (numberOfParts > 0) {
            step = difference / (double)numberOfParts;
        }
        Double[] linearpoints = new Double[numberOfParts + 1];
        for (int i = 0; i < numberOfParts + 1; ++i) {
            linearpoints[i] = Math.exp(logStart + (double)i * step);
            if (!(linearpoints[i] < 0.011)) continue;
            linearpoints[i] = 0.0;
        }
        return linearpoints;
    }

    public static ArrayList<Color> scatterColor(int nColors) {
        ArrayList<Color> colors = new ArrayList<Color>();
        float saturation = 1.0f;
        float brightness = 1.0f;
        for (int i = 0; i < nColors; ++i) {
            float ratio = (float)i * 1.5f / (float)nColors;
            if (i % 10 == 0) {
                brightness = (float)Math.max(0.1, (double)brightness - 0.1);
            }
            int rgb = Color.HSBtoRGB(ratio, brightness, saturation);
            Color color = new Color(rgb);
            colors.add(color);
        }
        return colors;
    }

    public class ClassStyleDef {
        Object from = 0;
        Object to = 0;

        public ClassStyleDef() {
        }

        public ClassStyleDef(Object from, Object to) {
            this.from = from;
            this.to = to;
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }

        public void setFrom(Object from) {
            this.from = from;
        }

        public void setTo(Object to) {
            this.to = to;
        }
    }
}

