/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.meta;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultCitationDate;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.identification.DefaultBrowseGraphic;
import org.geotoolkit.metadata.iso.identification.DefaultDataIdentification;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.DataIdentification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataEnricher {
    static final Logger logger = LoggerFactory.getLogger(MetadataEnricher.class);
    private Metadata toEnrich;
    private DefaultMetadata enriched;
    private ArrayList<String> messages = new ArrayList();
    private DefaultDataIdentification ident = null;

    public MetadataEnricher(Metadata toEnrich, boolean generateUUID) {
        this.toEnrich = toEnrich;
        this.enriched = MetadataEnricher.castMeta(toEnrich);
        if (generateUUID) {
            this.enriched.setFileIdentifier(UUID.randomUUID().toString());
        }
        if (this.enriched.getIdentificationInfo().isEmpty()) {
            this.ident = new DefaultDataIdentification();
            this.enriched.getIdentificationInfo().add(this.ident);
        } else {
            this.ident = new DefaultDataIdentification((DataIdentification)this.enriched.getIdentificationInfo().iterator().next());
        }
    }

    public void addPreview(String previewURL) {
        try {
            this.ident.getGraphicOverviews().add(new DefaultBrowseGraphic(new URI(previewURL)));
        }
        catch (URISyntaxException e) {
            String msg = "Unable to set preview, passed URI is " + previewURL + ", cause : " + e.getMessage();
            logger.warn(msg);
            this.messages.add(msg);
        }
    }

    public void setdistributionURIs(List<String> uris) {
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (String uri : uris) {
            try {
                transferOptions.getOnLines().add(new DefaultOnlineResource(new URI(uri)));
            }
            catch (URISyntaxException e) {
                String msg = "Unable to set transfer option, passed URI is " + uri + ", cause : " + e.getMessage();
                logger.warn(msg);
                this.messages.add(msg);
            }
        }
        distribution.getTransferOptions().add(transferOptions);
        this.enriched.setDistributionInfo((Distribution)distribution);
    }

    public void addDate(Date toAdd, DateType type) {
        DefaultCitationDate publishDate = new DefaultCitationDate(toAdd, type);
        if (this.ident.getCitation() == null) {
            DefaultCitation citation = new DefaultCitation();
            citation.getDates().add(publishDate);
        } else {
            this.ident.getCitation().getDates().add(publishDate);
        }
    }

    public DefaultMetadata getEnriched() {
        return this.enriched;
    }

    public Metadata getToEnrich() {
        return this.toEnrich;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }

    private static final DefaultMetadata castMeta(Metadata meta) {
        if (meta.getClass().isAssignableFrom(DefaultMetadata.class)) {
            return (DefaultMetadata)meta;
        }
        return new DefaultMetadata(meta);
    }
}

