/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.is;

import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.manager.GeoServerRESTStoreManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoServerDescriptor
implements Comparable<AbstractGeoServerDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(AbstractGeoServerDescriptor.class);
    private String url;
    private String user;
    private String password;

    public AbstractGeoServerDescriptor(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    public int compareTo(AbstractGeoServerDescriptor o) {
        Long localCount = 0L;
        Long otherCount = 0L;
        try {
            localCount = this.getHostedLayersCount();
            otherCount = o.getHostedLayersCount();
        }
        catch (MalformedURLException e) {
            log.warn("Unable to evaluate count. This could lead to unbalanced layer amounts between instances", (Throwable)e);
        }
        return localCount.compareTo(otherCount);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeoServerDescriptor other = (AbstractGeoServerDescriptor)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public abstract Long getHostedLayersCount() throws MalformedURLException;

    public abstract Set<String> getWorkspaces() throws MalformedURLException;

    public abstract Set<String> getStyles() throws MalformedURLException;

    public abstract Set<String> getDatastores(String var1) throws MalformedURLException;

    public GeoServerRESTReader getReader() throws MalformedURLException {
        return this.getManager().getReader();
    }

    public GeoServerRESTStoreManager getDataStoreManager() throws IllegalArgumentException, MalformedURLException {
        return this.getManager().getStoreManager();
    }

    public GeoServerRESTPublisher getPublisher() throws IllegalArgumentException, MalformedURLException {
        return this.getManager().getPublisher();
    }

    protected GeoServerRESTManager getManager() throws IllegalArgumentException, MalformedURLException {
        return new GeoServerRESTManager(new URL(this.url), this.user, this.password);
    }

    public void onChangedStyles() {
    }

    public void onChangedWorkspaces() {
    }

    public void onChangedDataStores() {
    }

    public void onChangedLayers() {
    }

    public String toString() {
        long layersCount = 0L;
        try {
            layersCount = this.getHostedLayersCount();
        }
        catch (Exception e) {
            log.warn("Unable to get layer count on {} ", (Object)this.url, (Object)e);
        }
        return "AbstractGeoServerDescriptor [url=" + this.url + ", user=" + this.user + ", password=" + this.password + ", layerCount=" + layersCount + "]";
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

