/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final Long DEFAULT_TTL = 60000L;
    private static Configuration singleton = null;
    public static final String GEOSERVER_HOSTED_LAYERS_TTL = "geoserver.cache.hostedLayers.TTL";
    public static final String GEOSERVER_STYLES_TTL = "geoserver.cache.hostedLayers.TTL";
    public static final String GEOSERVER_WORKSPACE_TTL = "geoserver.cache.hostedLayers.TTL";
    public static final String GEOSERVER_DATASTORE_TTL = "geoserver.cache.hostedLayers.TTL";
    public static final String IS_CACHE_TTL = "geoserver.cache.hostedLayers.TTL";
    public static final String IS_SERVICE_PROFILE_CATEGORY = "is.serviceProfile.category";
    public static final String IS_SERVICE_PROFILE_PLATFORM_NAME = "is.serviceProfile.platform.name";
    public static final String IS_ACCESS_POLICY = "is.accessPolicy";
    HashMap<String, String> properties;
    Properties props = new Properties();

    public static synchronized Configuration get() throws IOException {
        if (singleton == null) {
            singleton = new Configuration();
        }
        return singleton;
    }

    private Configuration() throws IOException {
        try {
            this.props.load(Configuration.class.getClassLoader().getResourceAsStream("gis-interface.properties"));
        }
        catch (IOException e) {
            log.warn("****************** Unable to load properties file ****************** ", (Throwable)e);
            throw e;
        }
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public static Long getTTL(String TTLParameter) {
        try {
            return Long.parseLong(Configuration.get().getProperty(TTLParameter));
        }
        catch (Exception e) {
            log.warn("Unable to get TTL " + TTLParameter, (Throwable)e);
            return DEFAULT_TTL;
        }
    }
}

