/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.is.cache;

import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.gis.Configuration;
import org.gcube.spatial.data.gis.is.CachedGeoServerDescriptor;
import org.gcube.spatial.data.gis.is.cache.GeoServerCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISGeoServerCache
extends GeoServerCache<CachedGeoServerDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(ISGeoServerCache.class);
    private static final ConcurrentHashMap<String, ConcurrentSkipListSet<CachedGeoServerDescriptor>> scopedMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> scopeLastUpdate = new ConcurrentHashMap();

    @Override
    protected synchronized SortedSet<CachedGeoServerDescriptor> getTheCache(Boolean forceUpdate) {
        String scope = ScopeUtils.getCurrentScope();
        if (forceUpdate.booleanValue() || !scopedMap.containsKey(scope) || System.currentTimeMillis() - ISGeoServerCache.getLastUpdate() > Configuration.getTTL("geoserver.cache.hostedLayers.TTL")) {
            try {
                log.debug("Going to retrieve information from IS. Scope is {} ", (Object)scope);
                List<CachedGeoServerDescriptor> retrieved = ISGeoServerCache.queryforGeoServer();
                scopedMap.put(scope, new ConcurrentSkipListSet<CachedGeoServerDescriptor>(retrieved));
                log.trace("Retrieved {} instances in {}", (Object)retrieved.size(), (Object)scope);
                ISGeoServerCache.setUpdated();
            }
            catch (IOException e) {
                log.error("Unable to query IS ", (Throwable)e);
            }
        }
        return scopedMap.get(scope);
    }

    private static synchronized Long getLastUpdate() {
        String scope = ScopeUtils.getCurrentScope();
        log.debug("Accessing lastUpdate in scope {} ", (Object)scope);
        return scopeLastUpdate.containsKey(scope) ? scopeLastUpdate.get(scope) : Long.valueOf(0L);
    }

    private static synchronized void setUpdated() {
        String scope = ScopeUtils.getCurrentScope();
        log.debug("Setting update for scope {} ", (Object)scope);
        scopeLastUpdate.put(scope, System.currentTimeMillis());
    }

    private static List<CachedGeoServerDescriptor> queryforGeoServer() throws IOException {
        ArrayList<CachedGeoServerDescriptor> toReturn = new ArrayList<CachedGeoServerDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        String category = Configuration.get().getProperty("is.serviceProfile.category");
        String name = Configuration.get().getProperty("is.serviceProfile.platform.name");
        log.debug("Querying IS for service profiles category {} , name {} ", (Object)category, (Object)name);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + name + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        List accesspoints = client.submit((Query)query);
        for (ServiceEndpoint.AccessPoint point : accesspoints) {
            try {
                toReturn.add(new CachedGeoServerDescriptor(point.address(), point.username(), StringEncrypter.getEncrypter().decrypt(point.password(), new Key[0])));
            }
            catch (Exception e) {
                log.warn("Skipping Geoserver at {}", (Object)point.address(), (Object)e);
            }
        }
        return toReturn;
    }
}

