/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.gcube.common.clients.Call;
import org.gcube.common.gxrest.request.GXWebTargetAdapterRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.spatial.data.clients.FollowRedirectFilter;
import org.gcube.spatial.data.clients.GenericLoginClient;
import org.gcube.spatial.data.clients.model.ConnectionDescriptor;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGenericRESTClient
implements GenericLoginClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractGenericRESTClient.class);
    private ConnectionDescriptor conn;
    private String basePath = null;
    private MediaType defaultMediaType = MediaType.APPLICATION_JSON_TYPE;
    private Set<Class<?>> toRegisterClasses = new HashSet();
    private Set<Object> toRegisterObjects = new HashSet<Object>();

    protected AbstractGenericRESTClient(ConnectionDescriptor conn) {
        this.conn = conn;
        this.toRegisterClasses.add(FollowRedirectFilter.class);
    }

    protected String getExistsPath() {
        return this.conn.getEndpoint();
    }

    public boolean exist() {
        try {
            this.get(this.getExistsPath());
            return true;
        }
        catch (IOException e) {
            log.warn("Unable to check instance " + this.conn, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            log.info("Server replied with error. Ignore this if it requires authentication. " + this.conn, (Throwable)e);
            return true;
        }
    }

    public ConnectionDescriptor getInstance() {
        return this.conn;
    }

    public void authenticate(AccessType type) {
        log.info("Setting access type {}\u00a0", (Object)type);
        this.conn.getCredentials().forEach(c -> {
            if (c.getAccessType().equals((Object)type)) {
                this.setHTTPBasicAuth(c.getUsername(), c.getPassword());
            }
        });
    }

    public void authenticate() {
        log.info("Setting default access type between credentials {}", (Object)this.conn.getCredentials());
        if (this.conn.getCredentials().size() > 0) {
            Credentials c = (Credentials)this.conn.getCredentials().get(0);
            this.setHTTPBasicAuth(c.getUsername(), c.getPassword());
        } else {
            log.info("No credentials found in connection descriptor {}\u00a0", (Object)this.conn);
        }
    }

    public void setHTTPBasicAuth(String user, String pwd) {
        log.info("Setting basic authentication, user : {}\u00a0", (Object)user);
        this.toRegisterObjects.add(HttpAuthenticationFeature.universal((String)user, (String)pwd));
    }

    protected void register(Class<?> providerClass) {
        this.toRegisterClasses.add(providerClass);
    }

    protected void register(Object provider) {
        this.toRegisterObjects.add(provider);
    }

    protected GXWebTargetAdapterRequest resolve() throws UnsupportedEncodingException {
        GXWebTargetAdapterRequest toReturn = GXWebTargetAdapterRequest.newHTTPSRequest((String)this.conn.getEndpoint());
        this.toRegisterClasses.forEach(clazz -> toReturn.register(clazz));
        this.toRegisterObjects.forEach(obj -> toReturn.register(obj));
        if (this.basePath != null) {
            return toReturn.path(this.basePath);
        }
        return toReturn;
    }

    protected <T> T makeCall(Call<GXWebTargetAdapterRequest, T> call) throws RemoteException, Exception {
        try {
            return (T)call.call((Object)this.resolve());
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
    }

    protected void delete(final String path) throws RemoteException, Exception {
        this.makeCall(new Call<GXWebTargetAdapterRequest, Object>(){

            public Object call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return AbstractGenericRESTClient.check(AbstractGenericRESTClient.this.resolve().path(path).delete(), null);
            }
        });
    }

    protected void post(String path, Object obj) throws RemoteException, Exception {
        this.post(path, Entity.entity((Object)obj, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected <T> T post(final String path, final Entity<?> entity, final Class<T> returnClazz, final Map<String, ?> queryParams) throws RemoteException, Exception {
        return this.makeCall(new Call<GXWebTargetAdapterRequest, T>(){

            public T call(GXWebTargetAdapterRequest endpoint) throws Exception {
                HashMap actualMap = new HashMap();
                queryParams.forEach((k, v) -> {
                    Object[] theArray = null;
                    if (!(v instanceof Collection)) {
                        theArray = new Object[]{v};
                    }
                    actualMap.put(k, theArray);
                });
                return AbstractGenericRESTClient.check(endpoint.path(path).queryParams(actualMap).post(entity), returnClazz);
            }
        });
    }

    protected void post(String path, Entity<?> entity) throws RemoteException, Exception {
        this.post(path, entity, null, Collections.emptyMap());
    }

    protected void put(String path, Object obj) throws Exception {
        this.post(path, Entity.entity((Object)obj, (MediaType)MediaType.APPLICATION_JSON_TYPE));
    }

    protected <T> T put(final String path, final Entity<?> entity, final Class<T> returnClazz) throws Exception {
        return this.makeCall(new Call<GXWebTargetAdapterRequest, T>(){

            public T call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return AbstractGenericRESTClient.check(endpoint.path(path).post(entity), returnClazz);
            }
        });
    }

    protected String get(String path) throws Exception {
        return this.get(path, String.class);
    }

    protected <T> T get(String path, Class<T> clazz) throws Exception {
        return this.get(path, clazz, this.defaultMediaType);
    }

    protected <T> T get(final String path, final Class<T> clazz, final String mediaType) throws Exception {
        return this.makeCall(new Call<GXWebTargetAdapterRequest, T>(){

            public T call(GXWebTargetAdapterRequest endpoint) throws Exception {
                return AbstractGenericRESTClient.check(endpoint.path(path).header("accept", (Object)mediaType).get(), clazz);
            }
        });
    }

    protected <T> T get(String path, Class<T> clazz, MediaType type) throws Exception {
        return this.get(path, clazz, type + "");
    }

    protected static <T> T check(GXInboundResponse resp, Class<T> clazz) throws RemoteException {
        try {
            log.debug("Checking Response [Status : {}, Msg : {}]", (Object)resp.getHTTPCode(), (Object)resp.getMessage());
            if (!resp.isSuccessResponse()) {
                RemoteException e = new RemoteException("Error received from server ");
                e.setRemoteMessage(resp.getMessage());
                e.setResponseHTTPCode(Integer.valueOf(resp.getHTTPCode()));
                e.setContent(resp.getStreamedContentAsString());
                throw e;
            }
            if (clazz == null) {
                return null;
            }
            if (clazz == String.class) {
                return (T)resp.getStreamedContentAsString();
            }
            return (T)resp.tryConvertStreamedContentFromJson(clazz);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("Unable to read  response from server.", (Throwable)e);
        }
    }

    public ConnectionDescriptor getConn() {
        return this.conn;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

