/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.clients;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowRedirectFilter
implements ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(FollowRedirectFilter.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatusInfo().getFamily() != Response.Status.Family.REDIRECTION) {
            return;
        }
        URI targetUri = responseContext.getLocation();
        URI originalURI = requestContext.getUri();
        log.debug("Following redirect from {}\u00a0to {}", (Object)originalURI, (Object)targetUri);
        Response resp = requestContext.getClient().target(targetUri).request().method(requestContext.getMethod());
        responseContext.setEntityStream((InputStream)resp.getEntity());
        responseContext.setStatusInfo(resp.getStatusInfo());
        responseContext.setStatus(resp.getStatus());
    }
}

