/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.metadata;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class TemplateCollection {
    @XmlElement(name="availableTemplates")
    private Set<TemplateDescriptor> availableTemplates = new HashSet<TemplateDescriptor>();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.availableTemplates != null && !this.availableTemplates.isEmpty()) {
            for (TemplateDescriptor inv : this.availableTemplates) {
                result = 31 * result + inv.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TemplateCollection other = (TemplateCollection)obj;
        if (this.availableTemplates == null) {
            if (other.availableTemplates != null) {
                return false;
            }
        } else {
            if (this.availableTemplates.size() != other.availableTemplates.size()) {
                return false;
            }
            for (TemplateDescriptor inv : this.availableTemplates) {
                if (other.availableTemplates.contains(inv)) continue;
                return false;
            }
        }
        return true;
    }

    public Set<TemplateDescriptor> getAvailableTemplates() {
        return this.availableTemplates;
    }

    public void setAvailableTemplates(Set<TemplateDescriptor> availableTemplates) {
        this.availableTemplates = availableTemplates;
    }

    public TemplateCollection() {
    }

    @ConstructorProperties(value={"availableTemplates"})
    public TemplateCollection(Set<TemplateDescriptor> availableTemplates) {
        this.availableTemplates = availableTemplates;
    }

    public String toString() {
        return "TemplateCollection(availableTemplates=" + this.getAvailableTemplates() + ")";
    }
}

