/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.services;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.services.CatalogDefinition;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ThreddsDefinition
extends ServiceDefinition {
    @XmlElement
    private List<CatalogDefinition> catalogs;

    @Override
    public ServiceDefinition.Type getType() {
        return ServiceDefinition.Type.THREDDS;
    }

    public void addCatalog(CatalogDefinition catalog) {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<CatalogDefinition>();
        }
        this.catalogs.add(catalog);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.catalogs != null && !this.catalogs.isEmpty()) {
            for (CatalogDefinition catalog : this.catalogs) {
                result = 31 * result + catalog.hashCode();
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThreddsDefinition other = (ThreddsDefinition)obj;
        if (this.catalogs == null || this.catalogs.isEmpty()) {
            if (other.catalogs != null && !other.catalogs.isEmpty()) {
                return false;
            }
        } else {
            if (this.catalogs.size() != other.catalogs.size()) {
                return false;
            }
            if (!other.catalogs.containsAll(this.catalogs)) {
                return false;
            }
        }
        return true;
    }

    public List<CatalogDefinition> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(List<CatalogDefinition> catalogs) {
        this.catalogs = catalogs;
    }

    public ThreddsDefinition() {
    }

    @ConstructorProperties(value={"catalogs"})
    public ThreddsDefinition(List<CatalogDefinition> catalogs) {
        this.catalogs = catalogs;
    }

    @Override
    public String toString() {
        return "ThreddsDefinition(catalogs=" + this.getCatalogs() + ")";
    }
}

