/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.service;

import java.beans.ConstructorProperties;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.NonNull;
import org.gcube.spatial.data.clients.model.engine.ComparableVersion;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Version {
    @NonNull
    private Short major;
    @NonNull
    private Short minor;
    @NonNull
    private Short build;

    public Version(Integer maj, Integer min, Integer build) {
        this(maj.shortValue(), min.shortValue(), build.shortValue());
    }

    public ComparableVersion asComparable() {
        return new ComparableVersion(this.major + "." + this.minor + "." + this.build);
    }

    @NonNull
    public Short getMajor() {
        return this.major;
    }

    @NonNull
    public Short getMinor() {
        return this.minor;
    }

    @NonNull
    public Short getBuild() {
        return this.build;
    }

    public void setMajor(@NonNull Short major) {
        if (major == null) {
            throw new NullPointerException("major");
        }
        this.major = major;
    }

    public void setMinor(@NonNull Short minor) {
        if (minor == null) {
            throw new NullPointerException("minor");
        }
        this.minor = minor;
    }

    public void setBuild(@NonNull Short build) {
        if (build == null) {
            throw new NullPointerException("build");
        }
        this.build = build;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version other = (Version)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Short this$major = this.getMajor();
        Short other$major = other.getMajor();
        if (this$major == null ? other$major != null : !((Object)this$major).equals(other$major)) {
            return false;
        }
        Short this$minor = this.getMinor();
        Short other$minor = other.getMinor();
        if (this$minor == null ? other$minor != null : !((Object)this$minor).equals(other$minor)) {
            return false;
        }
        Short this$build = this.getBuild();
        Short other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !((Object)this$build).equals(other$build));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Version;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Short $major = this.getMajor();
        result = result * 59 + ($major == null ? 0 : ((Object)$major).hashCode());
        Short $minor = this.getMinor();
        result = result * 59 + ($minor == null ? 0 : ((Object)$minor).hashCode());
        Short $build = this.getBuild();
        result = result * 59 + ($build == null ? 0 : ((Object)$build).hashCode());
        return result;
    }

    public String toString() {
        return "Version(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", build=" + this.getBuild() + ")";
    }

    @ConstructorProperties(value={"major", "minor", "build"})
    public Version(@NonNull Short major, @NonNull Short minor, @NonNull Short build) {
        if (major == null) {
            throw new NullPointerException("major");
        }
        if (minor == null) {
            throw new NullPointerException("minor");
        }
        if (build == null) {
            throw new NullPointerException("build");
        }
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public Version() {
    }
}

