/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatia.data.model.profiles;

import java.beans.ConstructorProperties;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.NonNull;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApplicationProfile {
    @NonNull
    private String serviceClass;
    @NonNull
    private String serviceName;
    @NonNull
    private Map<String, String> properties;

    public String getProperty(String propertyName) {
        return this.properties == null ? null : this.properties.get(propertyName);
    }

    public String toString() {
        return "ApplicationProfile [serviceClass=" + this.serviceClass + ", serviceName=" + this.serviceName + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry<String, String> prop : this.properties.entrySet()) {
                result = 31 * result + (prop.getKey() == null ? 0 : prop.getKey().hashCode());
                result = 31 * result + (prop.getValue() == null ? 0 : prop.getValue().hashCode());
            }
        }
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.serviceClass == null ? 0 : this.serviceClass.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationProfile other = (ApplicationProfile)obj;
        if (this.properties == null) {
            if (other.properties != null) {
                return false;
            }
        } else {
            if (this.properties.size() != other.properties.size()) {
                return false;
            }
            for (Map.Entry<String, String> prop : this.properties.entrySet()) {
                if (!other.properties.containsKey(prop.getKey())) {
                    return false;
                }
                if (prop.getValue().equals(other.properties.get(prop.getKey()))) continue;
                return false;
            }
        }
        if (this.serviceClass == null ? other.serviceClass != null : !this.serviceClass.equals(other.serviceClass)) {
            return false;
        }
        return !(this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName));
    }

    @NonNull
    public String getServiceClass() {
        return this.serviceClass;
    }

    @NonNull
    public String getServiceName() {
        return this.serviceName;
    }

    @NonNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setServiceClass(@NonNull String serviceClass) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        this.serviceClass = serviceClass;
    }

    public void setServiceName(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        this.serviceName = serviceName;
    }

    public void setProperties(@NonNull Map<String, String> properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.properties = properties;
    }

    public ApplicationProfile() {
    }

    @ConstructorProperties(value={"serviceClass", "serviceName", "properties"})
    public ApplicationProfile(@NonNull String serviceClass, @NonNull String serviceName, @NonNull Map<String, String> properties) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.properties = properties;
    }

    public static interface Properties {
        public static final String GEOSERVER_STORAGE = "geoserver.storage";
        public static final String GEOSERVER_WORKSPACE = "geoserver.workspace";
        public static final String GEONETWORK_CATEGORY = "geonetwork.category";
        public static final String GEONETWORK_STYLE = "geonetwork.style";
        public static final String THREDDS_CATALOG = "thredds.catalog";
    }
}

