/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.utils;

import javax.ws.rs.core.Response;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    public static <T> T check(GXInboundResponse resp, Class<T> clazz) throws RemoteException {
        try {
            log.debug("Checking Response {}", (Object)resp);
            if (resp.hasGXError() || !resp.getSource().getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                RemoteException e = new RemoteException("Error received from server");
                e.setRemoteMessage(resp.getMessage());
                e.setResponseHTTPCode(Integer.valueOf(resp.getHTTPCode()));
                e.setContent(resp.getStreamedContentAsString());
                throw e;
            }
            if (clazz == null) {
                return null;
            }
            if (clazz == String.class) {
                return (T)resp.getStreamedContentAsString();
            }
            return (T)resp.tryConvertStreamedContentFromJson(clazz);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("Unable to read  response from server.", (Throwable)e);
        }
    }

    public static Response check(GXInboundResponse resp) throws RemoteException {
        try {
            log.debug("Checking Response {}", (Object)resp);
            if (resp.hasGXError() || !resp.getSource().getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                RemoteException e = new RemoteException("Error received from server");
                e.setRemoteMessage(resp.getMessage());
                e.setResponseHTTPCode(Integer.valueOf(resp.getHTTPCode()));
                e.setContent(resp.getStreamedContentAsString());
                throw e;
            }
            return resp.getSource();
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RemoteException("Unable to read  response from server.", (Throwable)e);
        }
    }
}

