/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.utils;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeUtils {
    private static final Logger log = LoggerFactory.getLogger(ScopeUtils.class);

    public static String getCurrentScope() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.debug("Token is : " + token);
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getContext();
        }
        catch (Exception e) {
            log.debug("Unable to resolve token, checking scope provider..", (Throwable)e);
            return ScopeProvider.instance.get();
        }
    }

    public static String getCurrentCaller() {
        try {
            String token = SecurityTokenProvider.instance.get();
            log.debug("Token is : " + token);
            if (token == null) {
                throw new Exception("Security Token is null");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            return entry.getClientInfo().getId();
        }
        catch (Exception e) {
            log.debug("Unable to resolve token, checking scope provider..", (Throwable)e);
            return "Unidentified data-transfer user";
        }
    }
}

