/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.engine.GISManager;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDIManagerImpl
implements SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManagerImpl.class);
    GeoNetworkManager geonetworkManager;
    ThreddsManager threddsManager;
    GISManager gisManager;

    @Inject
    public SDIManagerImpl(GeoNetworkManager geonetworkManager, ThreddsManager threddsManager, GISManager gisManager) {
        this.geonetworkManager = geonetworkManager;
        this.threddsManager = threddsManager;
        this.gisManager = gisManager;
    }

    public ScopeConfiguration getContextConfiguration() {
        ScopeConfiguration toReturn = new ScopeConfiguration();
        toReturn.setContextName(ScopeUtils.getCurrentScopeName());
        try {
            toReturn.setGeonetworkConfiguration(this.geonetworkManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("Scope is not well configured. Missing GeoNetwork. ", (Throwable)e);
        }
        try {
            toReturn.setThreddsConfiguration(this.threddsManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("THREDDS not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        try {
            toReturn.setGeoserverClusterConfiguration(this.gisManager.getConfiguration());
        }
        catch (Exception e) {
            log.warn("GeoServer not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        return toReturn;
    }
}

