/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISUtils {
    private static final Logger log = LoggerFactory.getLogger(ISUtils.class);

    static List<ServiceEndpoint> queryForServiceEndpoints(String category, String platformName) {
        log.debug("Querying for Service Endpoints [category : {} , platformName : {}, currentScope : {} ]", new Object[]{category, platformName, ScopeUtils.getCurrentScope()});
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + category + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platformName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        return client.submit((Query)query);
    }

    static List<GCoreEndpoint> queryForGCoreEndpoint(String serviceClass, String serviceName) {
        log.debug("Querying for GCore Endpoints [ServiceClass : {} , ServiceName : {}, currentScope : {} ]", new Object[]{serviceClass, serviceName, ScopeUtils.getCurrentScope()});
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        return client.submit((Query)query);
    }
}

