package org.gcube.spatial.data.sdi.engine.impl.metadata.templates;

import java.util.Map;

import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataHandler;
import org.gcube.spatial.data.sdi.engine.impl.metadata.MetadataUtils.Position;
import org.gcube.spatial.data.sdi.model.metadata.TemplateDescriptor;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocation;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

@Getter
@AllArgsConstructor
public abstract class AbstractTemplate<T> {

	
	
	@Getter
	@Setter
	@ToString
	@AllArgsConstructor
	public static class InsertionPoint{
		private Position position;
		private String elementReference;
	}
	
		
	private String fileName;
	private InsertionPoint insertionPoint;
	private TemplateDescriptor descriptor;	
	
	public abstract T getInstantiationRequest(MetadataHandler original, TemplateInvocation invocation) throws InvalidTemplateInvocationException,Exception;
		
	protected String getParameter(String parameterName, Map<String,String> parameters, boolean mandatory,String defaultValue)throws InvalidTemplateInvocationException{
		if(parameters==null || parameters.isEmpty() || !parameters.containsKey(parameterName)) 
			if(mandatory) throw new InvalidTemplateInvocationException("Missing parameter "+parameterName+".");
			else return defaultValue;
		else return parameters.get(parameterName);
	}
}
