/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.model.health;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.Status;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ServiceHealthReport {
    private Level overallStatus;
    private List<Status> checkReports;

    public ServiceHealthReport(List<Status> checkReports) {
        this.checkReports = checkReports;
        this.overallStatus = Level.OK;
        for (Status st : checkReports) {
            if (st.getLevel().equals((Object)Level.ERROR)) {
                this.overallStatus = Level.ERROR;
                break;
            }
            if (!st.getLevel().equals((Object)Level.WARNING) || !this.overallStatus.equals((Object)Level.OK)) continue;
            this.overallStatus = Level.WARNING;
        }
    }

    public Level getOverallStatus() {
        return this.overallStatus;
    }

    public List<Status> getCheckReports() {
        return this.checkReports;
    }

    public void setOverallStatus(Level overallStatus) {
        this.overallStatus = overallStatus;
    }

    public void setCheckReports(List<Status> checkReports) {
        this.checkReports = checkReports;
    }

    public ServiceHealthReport() {
    }

    @ConstructorProperties(value={"overallStatus", "checkReports"})
    public ServiceHealthReport(Level overallStatus, List<Status> checkReports) {
        this.overallStatus = overallStatus;
        this.checkReports = checkReports;
    }

    public String toString() {
        return "ServiceHealthReport(overallStatus=" + this.getOverallStatus() + ", checkReports=" + this.getCheckReports() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceHealthReport)) {
            return false;
        }
        ServiceHealthReport other = (ServiceHealthReport)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Level this$overallStatus = this.getOverallStatus();
        Level other$overallStatus = other.getOverallStatus();
        if (this$overallStatus == null ? other$overallStatus != null : !this$overallStatus.equals(other$overallStatus)) {
            return false;
        }
        List this$checkReports = this.getCheckReports();
        List other$checkReports = other.getCheckReports();
        return !(this$checkReports == null ? other$checkReports != null : !((Object)this$checkReports).equals(other$checkReports));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceHealthReport;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Level $overallStatus = this.getOverallStatus();
        result = result * 59 + ($overallStatus == null ? 43 : $overallStatus.hashCode());
        List $checkReports = this.getCheckReports();
        result = result * 59 + ($checkReports == null ? 43 : ((Object)$checkReports).hashCode());
        return result;
    }
}

